/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.ByteUtils;
import com.github.marschall.storedprocedureproxy.OutParameterRegistration;
import java.sql.CallableStatement;
import java.sql.SQLException;

final class ByIndexAndTypeNameOutParameterRegistration
implements OutParameterRegistration {
    private final byte outParameterIndex;
    private final int outParameterType;
    private final String typeName;

    ByIndexAndTypeNameOutParameterRegistration(int outParameterIndex, int outParameterType, String typeName) {
        this.outParameterIndex = ByteUtils.toByte(outParameterIndex);
        this.outParameterType = outParameterType;
        this.typeName = typeName;
    }

    private int getOutParameterIndex() {
        return ByteUtils.toInt(this.outParameterIndex);
    }

    @Override
    public void bindOutParamter(CallableStatement statement) throws SQLException {
        statement.registerOutParameter(this.getOutParameterIndex(), this.outParameterType, this.typeName);
    }

    @Override
    public <T> T getOutParamter(CallableStatement statement, Class<T> type) throws SQLException {
        try {
            return statement.getObject(this.getOutParameterIndex(), type);
        }
        catch (SQLException e) {
            return type.cast(statement.getObject(this.getOutParameterIndex()));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[index=" + this.getOutParameterIndex() + ", type=" + this.outParameterType + ", typeName=" + this.typeName + ']';
    }
}

