/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.ByteUtils;
import com.github.marschall.storedprocedureproxy.OutParameterRegistration;
import java.sql.CallableStatement;
import java.sql.SQLException;

final class ByIndexOutParameterRegistration
implements OutParameterRegistration {
    private final byte outParameterIndex;
    private final int outParameterType;

    ByIndexOutParameterRegistration(int outParameterIndex, int outParameterType) {
        this.outParameterIndex = ByteUtils.toByte(outParameterIndex);
        this.outParameterType = outParameterType;
    }

    private int getOutParameterIndex() {
        return ByteUtils.toInt(this.outParameterIndex);
    }

    @Override
    public void bindOutParamter(CallableStatement statement) throws SQLException {
        statement.registerOutParameter(this.getOutParameterIndex(), this.outParameterType);
    }

    @Override
    public <T> T getOutParamter(CallableStatement statement, Class<T> type) throws SQLException {
        try {
            return statement.getObject(this.getOutParameterIndex(), type);
        }
        catch (SQLException e) {
            return type.cast(statement.getObject(this.getOutParameterIndex()));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[index=" + this.getOutParameterIndex() + ", type=" + this.outParameterType + ']';
    }
}

