/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.CallResource;
import com.github.marschall.storedprocedureproxy.InParameterRegistration;
import com.github.marschall.storedprocedureproxy.ToStringUtils;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.SQLException;

final class ByNameAndTypeInParameterRegistration
implements InParameterRegistration {
    private final String[] inParameterNames;
    private final int[] inParameterTypes;

    ByNameAndTypeInParameterRegistration(String[] inParameterNames, int[] inParameterTypes) {
        this.inParameterTypes = inParameterTypes;
        this.inParameterNames = inParameterNames;
    }

    @Override
    public void bindInParamters(CallableStatement statement, CallResource callResource, Object[] args) throws SQLException {
        for (int i = 0; i < args.length; ++i) {
            String parameterName = this.inParameterNames[i];
            if (parameterName == null) continue;
            Object arg = callResource.hasResourceAt(i) ? callResource.resourceAt(i) : args[i];
            int type = this.inParameterTypes[i];
            if (arg != null) {
                if (InParameterRegistration.hasScale(type) && arg instanceof BigDecimal) {
                    statement.setObject(parameterName, arg, type, ((BigDecimal)arg).scale());
                    continue;
                }
                statement.setObject(parameterName, arg, type);
                continue;
            }
            statement.setNull(parameterName, type);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("[names={");
        ToStringUtils.toStringOn(this.inParameterNames, builder);
        builder.append("}, types={");
        ToStringUtils.toStringOn(this.inParameterTypes, builder);
        builder.append("}]");
        return builder.toString();
    }
}

