/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.CallResource;
import com.github.marschall.storedprocedureproxy.InParameterRegistration;
import com.github.marschall.storedprocedureproxy.ToStringUtils;
import java.sql.CallableStatement;
import java.sql.SQLException;

final class ByNameInParameterRegistration
implements InParameterRegistration {
    private final String[] inParameterNames;

    ByNameInParameterRegistration(String[] inParameterNames) {
        this.inParameterNames = inParameterNames;
    }

    @Override
    public void bindInParamters(CallableStatement statement, CallResource callResource, Object[] args) throws SQLException {
        for (int i = 0; i < args.length; ++i) {
            String parameterName = this.inParameterNames[i];
            if (parameterName == null) continue;
            Object arg = callResource.hasResourceAt(i) ? callResource.resourceAt(i) : args[i];
            statement.setObject(parameterName, arg);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append('[');
        ToStringUtils.toStringOn(this.inParameterNames, builder);
        builder.append(']');
        return builder.toString();
    }
}

