/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.CallResource;
import com.github.marschall.storedprocedureproxy.CallResourceFactory;
import com.github.marschall.storedprocedureproxy.CompositeResource;
import com.github.marschall.storedprocedureproxy.ToStringUtils;
import java.sql.Connection;
import java.sql.SQLException;

final class CompositeFactory
implements CallResourceFactory {
    private final CallResourceFactory[] factories;

    CompositeFactory(CallResourceFactory[] factories) {
        this.factories = factories;
    }

    @Override
    public CallResource createResource(Connection connection, Object[] args) throws SQLException {
        CallResource[] resources = new CallResource[this.factories.length];
        for (int i = 0; i < this.factories.length; ++i) {
            CallResource resource;
            CallResourceFactory factory = this.factories[i];
            try {
                resource = factory.createResource(connection, args);
            }
            catch (SQLException e) {
                CompositeFactory.cleanUp(resources, i, e);
                throw e;
            }
            resources[i] = resource;
        }
        return new CompositeResource(resources);
    }

    private static void cleanUp(CallResource[] resources, int endIndex, SQLException originalException) {
        for (int i = 0; i < endIndex; ++i) {
            CallResource resource = resources[i];
            try {
                resource.close();
                continue;
            }
            catch (SQLException e) {
                originalException.addSuppressed(e);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append('[');
        ToStringUtils.toStringOn(this.factories, builder);
        builder.append(']');
        return builder.toString();
    }
}

