/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.CallResource;
import com.github.marschall.storedprocedureproxy.ToStringUtils;
import java.sql.SQLException;

final class CompositeResource
implements CallResource {
    private final CallResource[] resources;

    CompositeResource(CallResource[] resources) {
        this.resources = resources;
    }

    @Override
    public boolean hasResourceAt(int index) {
        for (CallResource resource : this.resources) {
            if (!resource.hasResourceAt(index)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object resourceAt(int index) {
        for (CallResource resource : this.resources) {
            if (!resource.hasResourceAt(index)) continue;
            return resource.resourceAt(index);
        }
        throw new IllegalArgumentException("no resource at: " + index);
    }

    @Override
    public void close() throws SQLException {
        SQLException firstException = null;
        for (CallResource resource : this.resources) {
            try {
                resource.close();
            }
            catch (SQLException e) {
                if (firstException == null) {
                    firstException = e;
                    continue;
                }
                firstException.addSuppressed(e);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append('[');
        ToStringUtils.toStringOn(this.resources, builder);
        builder.append(']');
        return builder.toString();
    }
}

