/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.spi.TypeMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class DefaultTypeMapper
implements TypeMapper {
    static final TypeMapper INSTANCE = new DefaultTypeMapper();
    private final Map<Class<?>, Integer> typeMap = new HashMap();

    private DefaultTypeMapper() {
        this.typeMap.put(String.class, 12);
        this.typeMap.put(Integer.class, 4);
        this.typeMap.put(Integer.TYPE, 4);
        this.typeMap.put(Long.class, -5);
        this.typeMap.put(Long.TYPE, -5);
        this.typeMap.put(Short.class, 5);
        this.typeMap.put(Short.TYPE, 5);
        this.typeMap.put(Byte.class, -6);
        this.typeMap.put(Byte.TYPE, -6);
        this.typeMap.put(BigDecimal.class, 2);
        this.typeMap.put(BigInteger.class, 2);
        this.typeMap.put(Float.class, 7);
        this.typeMap.put(Float.TYPE, 7);
        this.typeMap.put(Double.class, 8);
        this.typeMap.put(Double.TYPE, 8);
        this.typeMap.put(Blob.class, 2004);
        this.typeMap.put(Clob.class, 2005);
        this.typeMap.put(NClob.class, 2011);
        this.typeMap.put(LocalDate.class, 91);
        this.typeMap.put(LocalTime.class, 92);
        this.typeMap.put(LocalDateTime.class, 93);
        this.typeMap.put(OffsetTime.class, 2013);
        this.typeMap.put(OffsetDateTime.class, 2014);
        this.typeMap.put(Date.class, 91);
        this.typeMap.put(Time.class, 92);
        this.typeMap.put(Timestamp.class, 93);
        this.typeMap.put(SQLXML.class, 2009);
        this.typeMap.put(Boolean.class, 16);
        this.typeMap.put(Boolean.TYPE, 16);
        this.typeMap.put(Collection.class, 2003);
        this.typeMap.put(Set.class, 2003);
        this.typeMap.put(List.class, 2003);
    }

    @Override
    public int mapToSqlType(Class<?> javaType) {
        Integer sqlType = this.typeMap.get(javaType);
        if (sqlType == null) {
            if (javaType.isArray()) {
                return 2003;
            }
            throw new IllegalArgumentException("unknown type: " + javaType);
        }
        return sqlType;
    }
}

