/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.spi.TypeNameResolver;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

final class DefaultTypeNameResolver
implements TypeNameResolver {
    static final TypeNameResolver INSTANCE = new DefaultTypeNameResolver();
    private final Map<Class<?>, String> typeMap = new HashMap();

    private DefaultTypeNameResolver() {
        this.typeMap.put(String.class, "VARCHAR");
        this.typeMap.put(Integer.class, "INTEGER");
        this.typeMap.put(Integer.TYPE, "INTEGER");
        this.typeMap.put(Long.class, "BIGINT");
        this.typeMap.put(Long.TYPE, "BIGINT");
        this.typeMap.put(Short.class, "SMALLINT");
        this.typeMap.put(Short.TYPE, "SMALLINT");
        this.typeMap.put(Byte.class, "TINYINT");
        this.typeMap.put(Byte.TYPE, "TINYINT");
        this.typeMap.put(BigDecimal.class, "NUMERIC");
        this.typeMap.put(BigInteger.class, "NUMERIC");
        this.typeMap.put(Float.class, "REAL");
        this.typeMap.put(Float.TYPE, "REAL");
        this.typeMap.put(Double.class, "DOUBLE");
        this.typeMap.put(Double.TYPE, "DOUBLE");
        this.typeMap.put(LocalDate.class, "DATE");
        this.typeMap.put(LocalTime.class, "TIME");
        this.typeMap.put(LocalDateTime.class, "TIMESTAMP");
        this.typeMap.put(Date.class, "DATE");
        this.typeMap.put(Time.class, "TIME");
        this.typeMap.put(Timestamp.class, "TIMESTAMP");
        this.typeMap.put(Boolean.class, "BOOLEAN");
        this.typeMap.put(Boolean.TYPE, "BOOLEAN");
    }

    @Override
    public String resolveTypeName(Parameter parameter) {
        Class<?> elementType;
        Class<?> parameterType = parameter.getType();
        if (Collection.class.isAssignableFrom(parameterType)) {
            elementType = this.getCollectionTypeParameter(parameter);
        } else if (parameterType.isArray()) {
            elementType = parameterType.getComponentType();
        } else {
            throw new IllegalArgumentException("parameter " + parameter + " needs to be List or array");
        }
        String typeName = this.typeMap.get(elementType);
        if (typeName == null) {
            throw new IllegalArgumentException("SQL type for element type: " + elementType + " can not be determined");
        }
        return typeName;
    }

    private Class<?> getCollectionTypeParameter(Parameter parameter) {
        Type type = parameter.getParameterizedType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length != 1) {
                throw new IllegalArgumentException("type arguments of parameter " + parameter + " are missing");
            }
            Type actualTypeArgument = actualTypeArguments[0];
            if (!(actualTypeArgument instanceof Class)) {
                throw new IllegalArgumentException("type arguments of parameter" + parameter + " is not a class");
            }
            return (Class)actualTypeArgument;
        }
        throw new IllegalArgumentException("parameter " + parameter + " is missing type paramter for " + type);
    }
}

