/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.DefaultMethodSupport;
import com.github.marschall.storedprocedureproxy.ProcedureCallerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class Java9DefaultMethodSupport
implements DefaultMethodSupport {
    private static final MethodHandle CLASS_GETMODULE;
    private static final MethodHandle MODULE_ISNAMED;
    private static final MethodHandle MODULE_ADDREADS;
    private static final MethodHandle PRIVE_LOOKUP_IN;
    private final Class<?> interfaceDeclaration;
    private final Map<Method, MethodHandle> defaultMethodCache;
    private final ReadWriteLock cacheLock;

    Java9DefaultMethodSupport(Class<?> interfaceDeclaration) {
        this.interfaceDeclaration = interfaceDeclaration;
        this.defaultMethodCache = new HashMap<Method, MethodHandle>();
        this.cacheLock = new ReentrantReadWriteLock();
    }

    @Override
    public MethodHandle getDefaultMethodHandle(Object proxy, Method method) {
        MethodHandle methodHandle = this.getDefaultMethodHandleFromCacheOrNull(method);
        if (methodHandle != null) {
            return methodHandle;
        }
        methodHandle = this.lookupDefaultMethod(proxy, method);
        MethodHandle previous = this.tryWriteDefaultMethodHandleToCache(method, methodHandle);
        return previous != null ? previous : methodHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodHandle getDefaultMethodHandleFromCacheOrNull(Method method) {
        Lock lock = this.cacheLock.readLock();
        lock.lock();
        try {
            MethodHandle methodHandle = this.defaultMethodCache.get(method);
            return methodHandle;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodHandle tryWriteDefaultMethodHandleToCache(Method method, MethodHandle methodHandle) {
        Lock lock = this.cacheLock.writeLock();
        lock.lock();
        try {
            MethodHandle methodHandle2 = this.defaultMethodCache.putIfAbsent(method, methodHandle);
            return methodHandle2;
        }
        finally {
            lock.unlock();
        }
    }

    private MethodHandle lookupDefaultMethod(Object proxy, Method method) {
        try {
            MethodHandles.Lookup lookup;
            try {
                if (MODULE_ISNAMED.invoke(CLASS_GETMODULE.invoke(proxy.getClass()))) {
                    lookup = PRIVE_LOOKUP_IN.invoke(this.interfaceDeclaration, MethodHandles.lookup());
                } else {
                    MODULE_ADDREADS.invoke(CLASS_GETMODULE.invoke(proxy.getClass()));
                    lookup = PRIVE_LOOKUP_IN.invoke(proxy.getClass(), MethodHandles.lookup());
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException("create lookup for default method", e);
            }
            MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
            return lookup.findSpecial(this.interfaceDeclaration, method.getName(), methodType, this.interfaceDeclaration).bindTo(proxy);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("default method " + method + " is not accessible", e);
        }
    }

    static {
        MethodHandle privateLookupIn;
        MethodHandle moduleAddReads;
        MethodHandle moduleIsNamed;
        MethodHandle classGetModule;
        try {
            Class<?> moduleClass = Class.forName("java.lang.Module");
            MethodType returnsModule = MethodType.methodType(moduleClass);
            classGetModule = MethodHandles.publicLookup().findVirtual(Class.class, "getModule", returnsModule);
            MethodType returnsBoolean = MethodType.methodType(Boolean.TYPE);
            moduleIsNamed = MethodHandles.publicLookup().findVirtual(moduleClass, "isNamed", returnsBoolean);
            MethodType addReadsSignature = MethodType.methodType(moduleClass, moduleClass);
            moduleAddReads = MethodHandles.lookup().findVirtual(moduleClass, "addReads", addReadsSignature).bindTo(classGetModule.invoke(ProcedureCallerFactory.ParameterRegistration.class));
            MethodType privateLookupInSignature = MethodType.methodType(MethodHandles.Lookup.class, Class.class, MethodHandles.Lookup.class);
            privateLookupIn = MethodHandles.lookup().findStatic(MethodHandles.class, "privateLookupIn", privateLookupInSignature);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("could not initialize class", e);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("could not initialize class", e);
        }
        CLASS_GETMODULE = classGetModule;
        MODULE_ISNAMED = moduleIsNamed;
        MODULE_ADDREADS = moduleAddReads;
        PRIVE_LOOKUP_IN = privateLookupIn;
    }
}

