/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.OutParameterRegistration;
import com.github.marschall.storedprocedureproxy.ResultExtractor;
import com.github.marschall.storedprocedureproxy.ToStringUtils;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

final class ListResultExtractor
implements ResultExtractor {
    private final Class<?> listElementType;
    private final int fetchSize;

    ListResultExtractor(Class<?> listElementType, int fetchSize) {
        this.listElementType = listElementType;
        this.fetchSize = fetchSize;
    }

    @Override
    public Object extractResult(CallableStatement statement, OutParameterRegistration outParameterRegistration, Object[] args) throws SQLException {
        boolean hasResultSet;
        if (this.fetchSize != 0) {
            statement.setFetchSize(this.fetchSize);
        }
        if (hasResultSet = statement.execute()) {
            try (ResultSet rs = statement.getResultSet();){
                List<Object> list = ListResultExtractor.read(rs, this.listElementType);
                return list;
            }
        }
        try (ResultSet rs = ListResultExtractor.getOutResultSet(statement, outParameterRegistration);){
            List<Object> list = ListResultExtractor.read(rs, this.listElementType);
            return list;
        }
    }

    private static List<Object> read(ResultSet resultSet, Class<?> type) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        while (resultSet.next()) {
            Object element = resultSet.getObject(1, type);
            result.add(element);
        }
        return result;
    }

    private static ResultSet getOutResultSet(CallableStatement statement, OutParameterRegistration outParameterRegistration) throws SQLException {
        return outParameterRegistration.getOutParamter(statement, ResultSet.class);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type=" + ToStringUtils.classNameToString(this.listElementType) + ", fetchSize=" + ToStringUtils.fetchSizeToString(this.fetchSize) + ']';
    }
}

