/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.AbstractArrayFactory;
import com.github.marschall.storedprocedureproxy.ArrayResource;
import com.github.marschall.storedprocedureproxy.CallResource;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;

final class OracleArrayFactory
extends AbstractArrayFactory {
    private static final Class<?> ORACLE_CONNECTION;
    private static final MethodHandle CREATE_ORACLE_ARRAY;

    OracleArrayFactory(int argumentIndex, String typeName) {
        super(argumentIndex, typeName);
    }

    @Override
    public CallResource createResource(Connection connection, Object[] args) throws SQLException {
        if (ORACLE_CONNECTION == null || CREATE_ORACLE_ARRAY == null) {
            throw new IllegalStateException("Oracle JDBC classes not found in expected shape");
        }
        Object elements = this.extractElements(args);
        Array array = this.createOracleArray(elements, connection);
        return new ArrayResource(array, this.argumentIndex);
    }

    private Array createOracleArray(Object elements, Connection connection) throws SQLException {
        Array array;
        Object oracleConnection = connection.unwrap(ORACLE_CONNECTION);
        try {
            array = CREATE_ORACLE_ARRAY.invoke(oracleConnection, this.typeName, elements);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("unknwon exception occured when calling " + CREATE_ORACLE_ARRAY, e);
        }
        return array;
    }

    private Object extractElements(Object[] args) {
        Object elements = args[this.argumentIndex];
        if (elements instanceof Collection) {
            return ((Collection)elements).toArray();
        }
        if (elements instanceof Object[]) {
            return elements;
        }
        if (elements.getClass().isArray()) {
            return elements;
        }
        throw new IllegalArgumentException("argument at index: " + this.argumentIndex + " expected to be a collection or array but was not");
    }

    static {
        MethodHandle createARRAY;
        Class<?> oracleConnection;
        try {
            oracleConnection = Class.forName("oracle.jdbc.OracleConnection");
            Method createOracleArrayMethod = oracleConnection.getDeclaredMethod("createOracleArray", String.class, Object.class);
            createARRAY = MethodHandles.publicLookup().unreflect(createOracleArrayMethod);
        }
        catch (ReflectiveOperationException e) {
            oracleConnection = null;
            createARRAY = null;
        }
        ORACLE_CONNECTION = oracleConnection;
        CREATE_ORACLE_ARRAY = createARRAY;
    }
}

