/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.ArrayResultExtractor;
import com.github.marschall.storedprocedureproxy.OutParameterRegistration;
import com.github.marschall.storedprocedureproxy.ResultExtractor;
import com.github.marschall.storedprocedureproxy.ToStringUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

final class OracleArrayResultExtractor
implements ResultExtractor {
    private static final Class<?> ORACLE_ARRAY;
    private static final MethodHandle GET_LONG_ARRAY;
    private static final MethodHandle GET_INT_ARRAY;
    private static final MethodHandle GET_DOUBLE_ARRAY;
    private static final MethodHandle GET_FLOAT_ARRAY;
    private static final MethodHandle GET_SHORT_ARRAY;
    private final Class<?> arrayElementType;

    OracleArrayResultExtractor(Class<?> arrayElementType) {
        this.arrayElementType = arrayElementType;
    }

    @Override
    public Object extractResult(CallableStatement statement, OutParameterRegistration outParameterRegistration, Object[] args) throws SQLException {
        if (ORACLE_ARRAY == null) {
            throw new IllegalStateException("Oracle JDBC classes not available");
        }
        boolean hasResultSet = statement.execute();
        if (hasResultSet) {
            try (ResultSet rs = statement.getResultSet();){
                if (!rs.next()) {
                    throw new IllegalStateException("result set is empty");
                }
                Array array = (Array)rs.getObject(1, ORACLE_ARRAY);
                Object object = this.extractValue(array);
                return object;
            }
        }
        Array array = (Array)outParameterRegistration.getOutParamter(statement, ORACLE_ARRAY);
        return this.extractValue(array);
    }

    static boolean isSupportedElementType(Class<?> elementType) {
        return elementType.isPrimitive() && (elementType == Integer.TYPE || elementType == Long.TYPE || elementType == Float.TYPE || elementType == Double.TYPE || elementType == Short.TYPE);
    }

    private Object extractValue(Array array) throws SQLException {
        try {
            if (this.arrayElementType.isPrimitive()) {
                if (this.arrayElementType == Integer.TYPE) {
                    Object object = OracleArrayResultExtractor.getIntArray(array);
                    return object;
                }
                if (this.arrayElementType == Long.TYPE) {
                    Object object = OracleArrayResultExtractor.getLongArray(array);
                    return object;
                }
                if (this.arrayElementType == Float.TYPE) {
                    Object object = OracleArrayResultExtractor.getFloatArray(array);
                    return object;
                }
                if (this.arrayElementType == Double.TYPE) {
                    Object object = OracleArrayResultExtractor.getDoubleArray(array);
                    return object;
                }
                if (this.arrayElementType == Short.TYPE) {
                    Object object = OracleArrayResultExtractor.getShortArray(array);
                    return object;
                }
                throw new IllegalArgumentException("unsupported element type: " + this.arrayElementType);
            }
            throw new IllegalStateException("for reference arrays " + ArrayResultExtractor.class + " should be used");
        }
        finally {
            array.free();
        }
    }

    private static Object getShortArray(Array array) {
        try {
            return GET_SHORT_ARRAY.invoke(array);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("unknwon exception occured when calling " + GET_SHORT_ARRAY, e);
        }
    }

    private static Object getDoubleArray(Array array) {
        try {
            return GET_DOUBLE_ARRAY.invoke(array);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("unknwon exception occured when calling " + GET_DOUBLE_ARRAY, e);
        }
    }

    private static Object getFloatArray(Array array) {
        try {
            return GET_FLOAT_ARRAY.invoke(array);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("unknwon exception occured when calling " + GET_FLOAT_ARRAY, e);
        }
    }

    private static Object getLongArray(Array array) {
        try {
            return GET_LONG_ARRAY.invoke(array);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("unknwon exception occured when calling " + GET_LONG_ARRAY, e);
        }
    }

    private static Object getIntArray(Array array) {
        try {
            return GET_INT_ARRAY.invoke(array);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("unknwon exception occured when calling " + GET_INT_ARRAY, e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + ToStringUtils.classNameToString(this.arrayElementType) + ']';
    }

    static {
        MethodHandle getShortArray;
        MethodHandle getDoubleArray;
        MethodHandle getFloatArray;
        MethodHandle getIntArray;
        MethodHandle getLongArray;
        Class<?> oracleArray;
        try {
            oracleArray = Class.forName("oracle.jdbc.OracleArray");
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            getLongArray = lookup.unreflect(oracleArray.getDeclaredMethod("getLongArray", new Class[0]));
            getIntArray = lookup.unreflect(oracleArray.getDeclaredMethod("getIntArray", new Class[0]));
            getFloatArray = lookup.unreflect(oracleArray.getDeclaredMethod("getFloatArray", new Class[0]));
            getDoubleArray = lookup.unreflect(oracleArray.getDeclaredMethod("getDoubleArray", new Class[0]));
            getShortArray = lookup.unreflect(oracleArray.getDeclaredMethod("getShortArray", new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            oracleArray = null;
            getLongArray = null;
            getIntArray = null;
            getFloatArray = null;
            getDoubleArray = null;
            getShortArray = null;
        }
        ORACLE_ARRAY = oracleArray;
        GET_LONG_ARRAY = getLongArray;
        GET_INT_ARRAY = getIntArray;
        GET_DOUBLE_ARRAY = getDoubleArray;
        GET_FLOAT_ARRAY = getFloatArray;
        GET_SHORT_ARRAY = getShortArray;
    }
}

