/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.AbstractArrayFactory;
import com.github.marschall.storedprocedureproxy.ArrayResource;
import com.github.marschall.storedprocedureproxy.CallResource;
import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import org.postgresql.PGConnection;

final class PgArrayFactory
extends AbstractArrayFactory {
    PgArrayFactory(int argumentIndex, String typeName) {
        super(argumentIndex, typeName);
    }

    @Override
    public CallResource createResource(Connection connection, Object[] args) throws SQLException {
        Object elements = args[this.argumentIndex];
        if (elements != null && PgArrayFactory.isSupportedPrimitiveArray(elements.getClass())) {
            return this.createPgArrayOf(connection, elements);
        }
        return this.createArrayOf(connection, args);
    }

    private ArrayResource createPgArrayOf(Connection connection, Object elements) throws SQLException {
        PGConnection pgConnection = connection.unwrap(PGConnection.class);
        Array array = pgConnection.createArrayOf(this.typeName, elements);
        return new ArrayResource(array, this.argumentIndex);
    }

    private static boolean isSupportedPrimitiveArray(Class<?> clazz) {
        return clazz == long[].class || clazz == int[].class || clazz == short[].class || clazz == double[].class || clazz == float[].class || clazz == boolean[].class || clazz == String[].class;
    }
}

