/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.ArrayResourceFactoryFactory;
import com.github.marschall.storedprocedureproxy.ArrayResultExtractorFactory;
import com.github.marschall.storedprocedureproxy.ByIndexAndTypeInParameterRegistration;
import com.github.marschall.storedprocedureproxy.ByIndexAndTypeNameOutParameterRegistration;
import com.github.marschall.storedprocedureproxy.ByIndexInParameterRegistration;
import com.github.marschall.storedprocedureproxy.ByIndexOutParameterRegistration;
import com.github.marschall.storedprocedureproxy.ByNameAndTypeInParameterRegistration;
import com.github.marschall.storedprocedureproxy.ByNameAndTypeNameOutParameterRegistration;
import com.github.marschall.storedprocedureproxy.ByNameInParameterRegistration;
import com.github.marschall.storedprocedureproxy.ByNameOutParameterRegistration;
import com.github.marschall.storedprocedureproxy.ByteUtils;
import com.github.marschall.storedprocedureproxy.CallResource;
import com.github.marschall.storedprocedureproxy.CallResourceFactory;
import com.github.marschall.storedprocedureproxy.CompositeFactory;
import com.github.marschall.storedprocedureproxy.DefaultIncorrectResultSizeExceptionGenerator;
import com.github.marschall.storedprocedureproxy.DefaultMethodSupport;
import com.github.marschall.storedprocedureproxy.DefaultMethodSupportFactory;
import com.github.marschall.storedprocedureproxy.DefaultTypeMapper;
import com.github.marschall.storedprocedureproxy.DefaultTypeNameResolver;
import com.github.marschall.storedprocedureproxy.DelegatingTypeNameResolver;
import com.github.marschall.storedprocedureproxy.InParameterRegistration;
import com.github.marschall.storedprocedureproxy.IncorrectResultSizeExceptionGenerator;
import com.github.marschall.storedprocedureproxy.ListResultExtractor;
import com.github.marschall.storedprocedureproxy.NoInParameterRegistration;
import com.github.marschall.storedprocedureproxy.NoOutParameterRegistration;
import com.github.marschall.storedprocedureproxy.NoResourceFactory;
import com.github.marschall.storedprocedureproxy.NumberedValueExtractor;
import com.github.marschall.storedprocedureproxy.NumberedValueExtractorResultExtractor;
import com.github.marschall.storedprocedureproxy.OracleTypeMapper;
import com.github.marschall.storedprocedureproxy.OutParameterRegistration;
import com.github.marschall.storedprocedureproxy.PrefixByIndexInParameterRegistration;
import com.github.marschall.storedprocedureproxy.ResultExtractor;
import com.github.marschall.storedprocedureproxy.SQLExceptionAdapter;
import com.github.marschall.storedprocedureproxy.ScalarResultExtractor;
import com.github.marschall.storedprocedureproxy.SpringIncorrectResultSizeExceptionGenerator;
import com.github.marschall.storedprocedureproxy.SpringSQLExceptionAdapter;
import com.github.marschall.storedprocedureproxy.SuffixByIndexInParameterRegistration;
import com.github.marschall.storedprocedureproxy.UncheckedSQLExceptionAdapter;
import com.github.marschall.storedprocedureproxy.ValueExtractor;
import com.github.marschall.storedprocedureproxy.ValueExtractorResultExtractor;
import com.github.marschall.storedprocedureproxy.ValueExtractorUtils;
import com.github.marschall.storedprocedureproxy.VoidResultExtractor;
import com.github.marschall.storedprocedureproxy.annotations.FetchSize;
import com.github.marschall.storedprocedureproxy.annotations.InOutParameter;
import com.github.marschall.storedprocedureproxy.annotations.Namespace;
import com.github.marschall.storedprocedureproxy.annotations.OutParameter;
import com.github.marschall.storedprocedureproxy.annotations.ParameterName;
import com.github.marschall.storedprocedureproxy.annotations.ParameterType;
import com.github.marschall.storedprocedureproxy.annotations.ProcedureName;
import com.github.marschall.storedprocedureproxy.annotations.ReturnValue;
import com.github.marschall.storedprocedureproxy.annotations.Schema;
import com.github.marschall.storedprocedureproxy.spi.NamingStrategy;
import com.github.marschall.storedprocedureproxy.spi.TypeMapper;
import com.github.marschall.storedprocedureproxy.spi.TypeNameResolver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;

public final class ProcedureCallerFactory<T> {
    private static final boolean HAS_SPRING;
    private static final IncorrectResultSizeExceptionGenerator INCORRECT_RESULT_SIZE_EXCEPTION_GENERATOR;
    private static final TypeNameResolver DEFAULT_TYPE_NAME_RESOLVER;
    private final Class<T> interfaceDeclaration;
    private final DataSource dataSource;
    private NamingStrategy parameterNamingStrategy;
    private NamingStrategy procedureNamingStrategy;
    private NamingStrategy schemaNamingStrategy;
    private NamingStrategy namespaceNamingStrategy;
    private boolean hasSchema;
    private boolean hasNamespace;
    private ParameterRegistration parameterRegistration;
    private SQLExceptionAdapter exceptionAdapter;
    private TypeMapper typeMapper;
    private TypeNameResolver typeNameResolver;
    private ArrayResourceFactoryFactory arrayResourceFactoryFactory;
    private ArrayResultExtractorFactory arrayResultExtractorFactory;

    private ProcedureCallerFactory(Class<T> interfaceDeclaration, DataSource dataSource) {
        this.interfaceDeclaration = interfaceDeclaration;
        this.dataSource = dataSource;
        this.parameterNamingStrategy = NamingStrategy.IDENTITY;
        this.procedureNamingStrategy = NamingStrategy.IDENTITY;
        this.schemaNamingStrategy = NamingStrategy.IDENTITY;
        this.namespaceNamingStrategy = NamingStrategy.IDENTITY;
        this.hasSchema = false;
        this.hasNamespace = false;
        this.parameterRegistration = ParameterRegistration.INDEX_ONLY;
        this.exceptionAdapter = ProcedureCallerFactory.getDefaultExceptionAdapter(dataSource);
        this.typeMapper = DefaultTypeMapper.INSTANCE;
        this.typeNameResolver = DEFAULT_TYPE_NAME_RESOLVER;
        this.arrayResourceFactoryFactory = ArrayResourceFactoryFactory.JDBC;
        this.arrayResultExtractorFactory = ArrayResultExtractorFactory.JDBC;
    }

    private static SQLExceptionAdapter getDefaultExceptionAdapter(DataSource dataSource) {
        if (HAS_SPRING) {
            return new SpringSQLExceptionAdapter(dataSource);
        }
        return UncheckedSQLExceptionAdapter.INSTANCE;
    }

    public static <T> ProcedureCallerFactory<T> of(Class<T> inferfaceDeclaration, DataSource dataSource) {
        Objects.requireNonNull(inferfaceDeclaration);
        Objects.requireNonNull(dataSource);
        return new ProcedureCallerFactory<T>(inferfaceDeclaration, dataSource);
    }

    public static <T> T build(Class<T> inferfaceDeclaration, DataSource dataSource) {
        return ProcedureCallerFactory.of(inferfaceDeclaration, dataSource).build();
    }

    public ProcedureCallerFactory<T> withParameterNamingStrategy(NamingStrategy parameterNamingStrategy) {
        Objects.requireNonNull(parameterNamingStrategy);
        this.parameterNamingStrategy = parameterNamingStrategy;
        return this;
    }

    public ProcedureCallerFactory<T> withProcedureNamingStrategy(NamingStrategy procedureNamingStrategy) {
        Objects.requireNonNull(procedureNamingStrategy);
        this.procedureNamingStrategy = procedureNamingStrategy;
        return this;
    }

    public ProcedureCallerFactory<T> withSchemaNamingStrategy(NamingStrategy schemaNamingStrategy) {
        Objects.requireNonNull(schemaNamingStrategy);
        this.schemaNamingStrategy = schemaNamingStrategy;
        this.hasSchema = true;
        return this;
    }

    public ProcedureCallerFactory<T> withSchema() {
        this.hasSchema = true;
        return this;
    }

    public ProcedureCallerFactory<T> withNamespaceNamingStrategy(NamingStrategy namespaceNamingStrategy) {
        Objects.requireNonNull(namespaceNamingStrategy);
        this.namespaceNamingStrategy = namespaceNamingStrategy;
        this.hasNamespace = true;
        return this;
    }

    public ProcedureCallerFactory<T> withNamespace() {
        this.hasNamespace = true;
        return this;
    }

    public ProcedureCallerFactory<T> withParameterRegistration(ParameterRegistration parameterRegistration) {
        Objects.requireNonNull(parameterRegistration);
        this.parameterRegistration = parameterRegistration;
        return this;
    }

    public ProcedureCallerFactory<T> withExceptionAdapter(SQLExceptionAdapter exceptionAdapter) {
        Objects.requireNonNull(exceptionAdapter);
        this.exceptionAdapter = exceptionAdapter;
        return this;
    }

    public ProcedureCallerFactory<T> withTypeMapper(TypeMapper typeMapper) {
        Objects.requireNonNull(typeMapper);
        this.typeMapper = typeMapper;
        return this;
    }

    public ProcedureCallerFactory<T> withTypeNameResolver(TypeNameResolver typeNameResolver) {
        Objects.requireNonNull(typeNameResolver);
        this.typeNameResolver = new DelegatingTypeNameResolver(typeNameResolver);
        return this;
    }

    public ProcedureCallerFactory<T> withOracleArrays() {
        this.arrayResourceFactoryFactory = ArrayResourceFactoryFactory.ORACLE;
        this.arrayResultExtractorFactory = ArrayResultExtractorFactory.ORACLE;
        return this;
    }

    public ProcedureCallerFactory<T> withPostgresArrays() {
        this.arrayResourceFactoryFactory = ArrayResourceFactoryFactory.POSTGRES;
        return this;
    }

    public ProcedureCallerFactory<T> withOracleTypeMapper() {
        return this.withTypeMapper(OracleTypeMapper.INSTANCE);
    }

    public ProcedureCallerFactory<T> withOracleExtensions() {
        this.withOracleArrays();
        return this.withOracleTypeMapper();
    }

    public T build() {
        ProcedureCaller caller = new ProcedureCaller(this.dataSource, this.interfaceDeclaration, this.parameterNamingStrategy, this.procedureNamingStrategy, this.schemaNamingStrategy, this.hasSchema, this.namespaceNamingStrategy, this.hasNamespace, this.parameterRegistration, this.exceptionAdapter, this.typeMapper, this.typeNameResolver, this.arrayResourceFactoryFactory, this.arrayResultExtractorFactory);
        Object proxy = Proxy.newProxyInstance(this.interfaceDeclaration.getClassLoader(), new Class[]{this.interfaceDeclaration}, (InvocationHandler)caller);
        return this.interfaceDeclaration.cast(proxy);
    }

    static RuntimeException newIncorrectResultSizeException(int expectedSize, int actualSize) {
        return INCORRECT_RESULT_SIZE_EXCEPTION_GENERATOR.newIncorrectResultSizeException(expectedSize, actualSize);
    }

    static {
        IncorrectResultSizeExceptionGenerator incorrectResultSizeExceptionGenerator;
        boolean hasSpring;
        DEFAULT_TYPE_NAME_RESOLVER = new DelegatingTypeNameResolver(DefaultTypeNameResolver.INSTANCE);
        try {
            Class.forName("org.springframework.jdbc.support.SQLExceptionTranslator", false, ProcedureCallerFactory.class.getClassLoader());
            hasSpring = true;
            incorrectResultSizeExceptionGenerator = new SpringIncorrectResultSizeExceptionGenerator();
        }
        catch (ClassNotFoundException e) {
            hasSpring = false;
            incorrectResultSizeExceptionGenerator = new DefaultIncorrectResultSizeExceptionGenerator();
        }
        HAS_SPRING = hasSpring;
        INCORRECT_RESULT_SIZE_EXCEPTION_GENERATOR = incorrectResultSizeExceptionGenerator;
    }

    static final class CallInfo {
        final String procedureName;
        final String callString;
        final boolean wantsExceptionTranslation;
        final ResultExtractor resultExtractor;
        final OutParameterRegistration outParameterRegistration;
        final InParameterRegistration inParameterRegistration;
        final CallResourceFactory callResourceFactory;

        CallInfo(String procedureName, String callString, boolean wantsExceptionTranslation, ResultExtractor resultExtractor, OutParameterRegistration outParameterRegistration, InParameterRegistration inParameterRegistration, CallResourceFactory callResourceFactory) {
            this.procedureName = procedureName;
            this.callString = callString;
            this.wantsExceptionTranslation = wantsExceptionTranslation;
            this.resultExtractor = resultExtractor;
            this.outParameterRegistration = outParameterRegistration;
            this.inParameterRegistration = inParameterRegistration;
            this.callResourceFactory = callResourceFactory;
        }

        public String toString() {
            return "call '" + this.procedureName + "' using call string \"" + this.callString + '\"' + (this.wantsExceptionTranslation ? " with exception translation" : " without exception translation") + ", resultExtractor: " + this.resultExtractor + ", outParameterRegistration: " + this.outParameterRegistration + ", inParameterRegistration: " + this.inParameterRegistration + ", callResourceFactory: " + this.callResourceFactory;
        }
    }

    static final class ProcedureCaller
    implements InvocationHandler {
        static final int DEFAULT_FETCH_SIZE = 0;
        private static final int NO_OUT_PARAMTER = -1;
        private static final int NO_VALUE_EXTRACTOR = -1;
        static final int NO_IN_PARAMTER = 0;
        private final DataSource dataSource;
        private final Class<?> interfaceDeclaration;
        private final NamingStrategy parameterNamingStrategy;
        private final NamingStrategy procedureNamingStrategy;
        private final NamingStrategy schemaNamingStrategy;
        private final NamingStrategy namespaceNamingStrategy;
        private final boolean hasSchema;
        private final boolean hasNamespace;
        private final ParameterRegistration parameterRegistration;
        private final SQLExceptionAdapter exceptionAdapter;
        private final TypeMapper typeMapper;
        private final TypeNameResolver typeNameResolver;
        private final Map<Method, CallInfo> callInfoCache;
        private final ReadWriteLock cacheLock;
        private final ArrayResourceFactoryFactory arrayResourceFactoryFactory;
        private final ArrayResultExtractorFactory arrayResultExtractorFactory;
        private final DefaultMethodSupport defaultMethodSupport;

        ProcedureCaller(DataSource dataSource, Class<?> interfaceDeclaration, NamingStrategy parameterNamingStrategy, NamingStrategy procedureNamingStrategy, NamingStrategy schemaNamingStrategy, boolean hasSchemaName, NamingStrategy namespaceNamingStrategy, boolean hasNamespace, ParameterRegistration parameterRegistration, SQLExceptionAdapter exceptionAdapter, TypeMapper typeMapper, TypeNameResolver typeNameResolver, ArrayResourceFactoryFactory arrayResourceFactoryFactory, ArrayResultExtractorFactory arrayResultExtractorFactory) {
            this.dataSource = dataSource;
            this.interfaceDeclaration = interfaceDeclaration;
            this.parameterNamingStrategy = parameterNamingStrategy;
            this.procedureNamingStrategy = procedureNamingStrategy;
            this.schemaNamingStrategy = schemaNamingStrategy;
            this.hasSchema = hasSchemaName;
            this.namespaceNamingStrategy = namespaceNamingStrategy;
            this.hasNamespace = hasNamespace;
            this.parameterRegistration = parameterRegistration;
            this.exceptionAdapter = exceptionAdapter;
            this.typeMapper = typeMapper;
            this.typeNameResolver = typeNameResolver;
            this.arrayResourceFactoryFactory = arrayResourceFactoryFactory;
            this.arrayResultExtractorFactory = arrayResultExtractorFactory;
            this.callInfoCache = new HashMap<Method, CallInfo>();
            this.cacheLock = new ReentrantReadWriteLock();
            this.defaultMethodSupport = DefaultMethodSupportFactory.newInstance(interfaceDeclaration);
        }

        /*
         * Exception decompiling
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static void bindParameters(Object[] args, CallInfo callInfo, CallableStatement statement, CallResource callResource) throws SQLException {
            callInfo.outParameterRegistration.bindOutParamter(statement);
            callInfo.inParameterRegistration.bindInParamters(statement, callResource, args);
        }

        private static Class<?> getBoxedClass(Class<?> clazz) {
            if (clazz == Void.TYPE) {
                return clazz;
            }
            if (!clazz.isPrimitive()) {
                return clazz;
            }
            return ProcedureCaller.getWrapperClass(clazz);
        }

        private static Class<?> getWrapperClass(Class<?> primitiveClass) {
            if (primitiveClass == Integer.TYPE) {
                return Integer.class;
            }
            if (primitiveClass == Long.TYPE) {
                return Long.class;
            }
            if (primitiveClass == Float.TYPE) {
                return Float.class;
            }
            if (primitiveClass == Double.TYPE) {
                return Double.class;
            }
            if (primitiveClass == Byte.TYPE) {
                return Byte.class;
            }
            if (primitiveClass == Short.TYPE) {
                return Short.class;
            }
            if (primitiveClass == Character.TYPE) {
                return Character.class;
            }
            if (primitiveClass == Boolean.TYPE) {
                return Boolean.class;
            }
            throw new IllegalArgumentException("unknown primitive type: " + primitiveClass);
        }

        private Exception translate(SQLException exception, CallInfo callInfo) {
            if (callInfo.wantsExceptionTranslation) {
                return this.exceptionAdapter.translate(callInfo.procedureName, callInfo.callString, exception);
            }
            return exception;
        }

        private static Object execute(CallableStatement statement, CallInfo callInfo, Object[] args) throws SQLException {
            return callInfo.resultExtractor.extractResult(statement, callInfo.outParameterRegistration, args);
        }

        private String[] extractParameterNames(Method method) {
            Parameter[] parameters = method.getParameters();
            String[] names = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                names[i] = this.getParameterName(parameter, method, i);
            }
            return names;
        }

        private String getParameterName(Parameter parameter, Method method, int parameterIndex) {
            if (ValueExtractorUtils.isAnyValueExtractor(parameter.getType())) {
                return null;
            }
            ParameterName annotation = parameter.getAnnotation(ParameterName.class);
            if (annotation != null) {
                return annotation.value();
            }
            if (parameter.isNamePresent()) {
                return this.parameterNamingStrategy.translateToDatabase(parameter.getName());
            }
            throw new IllegalArgumentException(ProcedureCaller.parameterNameMissingMessage(method, parameterIndex));
        }

        private static String parameterNameMissingMessage(Method method, int i) {
            return "can't deduce name for parameter " + i + " in " + method + " either use " + ParameterName.class + " or compile with -parameters";
        }

        private int[] extractParameterTypes(Method method) {
            Parameter[] parameters = method.getParameters();
            int[] types = new int[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                types[i] = this.getParameterType(parameter);
            }
            return types;
        }

        private int getParameterType(Parameter parameter) {
            Class<?> parameterType = parameter.getType();
            if (ValueExtractorUtils.isAnyValueExtractor(parameterType)) {
                return 0;
            }
            ParameterType annotation = parameter.getAnnotation(ParameterType.class);
            if (annotation != null) {
                return annotation.value();
            }
            return this.typeMapper.mapToSqlType(parameterType);
        }

        private static CallableStatement prepareCall(Connection connection, CallInfo callInfo) throws SQLException {
            return connection.prepareCall(callInfo.callString);
        }

        private CallInfo getCallInfo(Method method, Object[] args) {
            CallInfo callInfo = this.getCallInfoFromCacheOrNull(method);
            if (callInfo != null) {
                return callInfo;
            }
            callInfo = this.buildCallInfo(method, args);
            CallInfo previous = this.tryWriteCallInfoToCache(method, callInfo);
            return previous != null ? previous : callInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CallInfo getCallInfoFromCacheOrNull(Method method) {
            Lock lock = this.cacheLock.readLock();
            lock.lock();
            try {
                CallInfo callInfo = this.callInfoCache.get(method);
                return callInfo;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CallInfo tryWriteCallInfoToCache(Method method, CallInfo callInfo) {
            Lock lock = this.cacheLock.writeLock();
            lock.lock();
            try {
                CallInfo callInfo2 = this.callInfoCache.putIfAbsent(method, callInfo);
                return callInfo2;
            }
            finally {
                lock.unlock();
            }
        }

        private CallInfo buildCallInfo(Method method, Object[] args) {
            int sqlInputParameterCount = ProcedureCaller.getInputParameterCount(method);
            String procedureName = this.extractProcedureName(method);
            Class<?> methodReturnType = method.getReturnType();
            int outParameterSqlIndex = ProcedureCaller.getOutParameterSqlIndex(method);
            boolean hasOutParameter = outParameterSqlIndex != -1;
            InParameterRegistration inParameterRegistration = this.buildInParameterRegistration(method, sqlInputParameterCount, outParameterSqlIndex);
            OutParameterRegistration outParameterRegistration = this.buildOutParameterRegistration(method, outParameterSqlIndex, hasOutParameter);
            CallResourceFactory callResourceFactory = this.buildCallResourceFactory(method);
            String callString = this.buildCallString(method, procedureName, sqlInputParameterCount, hasOutParameter);
            boolean wantsExceptionTranslation = ProcedureCaller.wantsExceptionTranslation(method);
            ResultExtractor resultExtractor = this.buildResultExtractor(method, methodReturnType);
            return new CallInfo(procedureName, callString, wantsExceptionTranslation, resultExtractor, outParameterRegistration, inParameterRegistration, callResourceFactory);
        }

        private CallResourceFactory buildCallResourceFactory(Method method) {
            int arrayCount = 0;
            for (Class<?> parameterType : method.getParameterTypes()) {
                if (!ProcedureCaller.isCollection(parameterType)) continue;
                ++arrayCount;
            }
            if (arrayCount == 0) {
                return NoResourceFactory.INSTANCE;
            }
            if (arrayCount == 1) {
                Parameter[] parameters = method.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    Parameter parameter = parameters[i];
                    if (!ProcedureCaller.isCollection(parameter.getType())) continue;
                    return this.createArrayResourceFactory(parameter, i);
                }
                throw new AssertionError((Object)"inconsistent state we checked for an array but found none");
            }
            CallResourceFactory[] factories = new CallResourceFactory[arrayCount];
            int factoryIndex = 0;
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                if (!ProcedureCaller.isCollection(parameter.getType())) continue;
                factories[factoryIndex++] = this.createArrayResourceFactory(parameter, i);
            }
            return new CompositeFactory(factories);
        }

        private static boolean isCollection(Class<?> parameterType) {
            return parameterType.isArray() || Collection.class.isAssignableFrom(parameterType);
        }

        private CallResourceFactory createArrayResourceFactory(Parameter parameter, int parameterIndex) {
            String typeName = this.typeNameResolver.resolveTypeName(parameter);
            return this.arrayResourceFactoryFactory.createArrayFactory(parameterIndex, typeName);
        }

        private InParameterRegistration buildInParameterRegistration(Method method, int sqlParameterCount, int outParameterSqlIndex) {
            boolean hasOutParameter;
            boolean bl = hasOutParameter = !method.isAnnotationPresent(InOutParameter.class) && outParameterSqlIndex != -1;
            if (sqlParameterCount > 0) {
                switch (this.parameterRegistration) {
                    case INDEX_ONLY: {
                        int valueExtractorIndex = ProcedureCaller.getValueExtractorIndex(method);
                        int javaParameterCount = method.getParameterCount();
                        if (valueExtractorIndex == -1) {
                            if (hasOutParameter && outParameterSqlIndex == 1) {
                                return PrefixByIndexInParameterRegistration.INSTANCE;
                            }
                            if (!hasOutParameter || outParameterSqlIndex == javaParameterCount + 1) {
                                return SuffixByIndexInParameterRegistration.INSTANCE;
                            }
                        }
                        byte[] inParameterIndices = ProcedureCaller.buildInParameterIndices(method, javaParameterCount, hasOutParameter, outParameterSqlIndex);
                        return new ByIndexInParameterRegistration(inParameterIndices);
                    }
                    case INDEX_AND_TYPE: {
                        int javaParameterCount = method.getParameterCount();
                        byte[] inParameterIndices = ProcedureCaller.buildInParameterIndices(method, javaParameterCount, hasOutParameter, outParameterSqlIndex);
                        int[] inParameterTypes = this.extractParameterTypes(method);
                        return new ByIndexAndTypeInParameterRegistration(inParameterIndices, inParameterTypes);
                    }
                    case NAME_ONLY: {
                        String[] inParameterNames = this.extractParameterNames(method);
                        return new ByNameInParameterRegistration(inParameterNames);
                    }
                    case NAME_AND_TYPE: {
                        String[] inParameterNames = this.extractParameterNames(method);
                        int[] inParameterTypes = this.extractParameterTypes(method);
                        return new ByNameAndTypeInParameterRegistration(inParameterNames, inParameterTypes);
                    }
                }
                throw new IllegalStateException("unknown parameter registration: " + (Object)((Object)this.parameterRegistration));
            }
            return NoInParameterRegistration.INSTANCE;
        }

        private ResultExtractor buildResultExtractor(Method method, Class<?> methodReturnType) {
            boolean isArray;
            boolean methodHasReturnValue = methodReturnType != Void.TYPE;
            boolean isList = methodHasReturnValue && methodReturnType == List.class;
            boolean bl = isArray = methodHasReturnValue && methodReturnType.isArray();
            if (!methodHasReturnValue) {
                return VoidResultExtractor.INSTANCE;
            }
            if (isList) {
                int valueExtractorIndex = ProcedureCaller.getValueExtractorIndex(method);
                int fetchSize = ProcedureCaller.getFetchSize(method);
                if (valueExtractorIndex == -1) {
                    Class<?> listElementType = ProcedureCaller.getListReturnTypeParamter(method);
                    return new ListResultExtractor(listElementType, fetchSize);
                }
                Class<?> parameterType = method.getParameterTypes()[valueExtractorIndex];
                if (ValueExtractorUtils.isValueExtractor(parameterType)) {
                    return new ValueExtractorResultExtractor(valueExtractorIndex, fetchSize);
                }
                if (ValueExtractorUtils.isNumberedValueExtractor(parameterType)) {
                    return new NumberedValueExtractorResultExtractor(valueExtractorIndex, fetchSize);
                }
                throw new IllegalStateException("unknown type of value extractor: " + parameterType);
            }
            if (isArray) {
                return this.arrayResultExtractorFactory.newArrayResultExtractor(methodReturnType);
            }
            Class<?> boxedReturnType = ProcedureCaller.getBoxedClass(method.getReturnType());
            return new ScalarResultExtractor(boxedReturnType);
        }

        private static byte[] buildInParameterIndices(Method method, int javaParameterCount, boolean hasOutParameter, int outParameterSqlIndex) {
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            if (!hasOutParameter || hasOutParameter && outParameterSqlIndex == javaParameterCount + 1) {
                return ProcedureCaller.buildInParameterIndices(javaParameterCount, methodParameterTypes);
            }
            return ProcedureCaller.buildInParameterIndices(javaParameterCount, outParameterSqlIndex, methodParameterTypes);
        }

        private OutParameterRegistration buildOutParameterRegistration(Method method, int outParameterSqlIndex, boolean hasOutParameter) {
            if (hasOutParameter) {
                InOutParameter inOutParameter = method.getAnnotation(InOutParameter.class);
                if (inOutParameter == null) {
                    int outParameterType = this.getOutParameterType(method);
                    String returnTypeName = ProcedureCaller.getReturnTypeName(method);
                    switch (this.parameterRegistration) {
                        case INDEX_ONLY: 
                        case INDEX_AND_TYPE: {
                            return ProcedureCaller.createIndexedOutParameterRegistration(outParameterSqlIndex, outParameterType, returnTypeName);
                        }
                        case NAME_ONLY: 
                        case NAME_AND_TYPE: {
                            String outParameterName = ProcedureCaller.getOutParameterName(method);
                            return ProcedureCaller.createNamedOutParameterRegistration(outParameterType, returnTypeName, outParameterName);
                        }
                    }
                    throw new IllegalStateException("unknown parameter registration: " + (Object)((Object)this.parameterRegistration));
                }
                int outParameterIndex = outParameterSqlIndex - 1;
                Parameter parameter = method.getParameters()[outParameterSqlIndex - 1];
                int outParameterType = this.getParameterType(parameter);
                String typeName = ProcedureCaller.isCollection(parameter.getType()) ? this.typeNameResolver.resolveTypeName(parameter) : null;
                switch (this.parameterRegistration) {
                    case INDEX_ONLY: 
                    case INDEX_AND_TYPE: {
                        return ProcedureCaller.createIndexedOutParameterRegistration(outParameterSqlIndex, outParameterType, typeName);
                    }
                    case NAME_ONLY: 
                    case NAME_AND_TYPE: {
                        String outParameterName = this.getParameterName(parameter, method, outParameterIndex);
                        return ProcedureCaller.createNamedOutParameterRegistration(outParameterType, typeName, outParameterName);
                    }
                }
                throw new IllegalStateException("unknown parameter registration: " + (Object)((Object)this.parameterRegistration));
            }
            return NoOutParameterRegistration.INSTANCE;
        }

        private static OutParameterRegistration createNamedOutParameterRegistration(int outParameterType, String returnTypeName, String outParameterName) {
            if (returnTypeName == null) {
                return new ByNameOutParameterRegistration(outParameterName, outParameterType);
            }
            return new ByNameAndTypeNameOutParameterRegistration(outParameterName, outParameterType, returnTypeName);
        }

        private static OutParameterRegistration createIndexedOutParameterRegistration(int outParameterSqlIndex, int outParameterType, String returnTypeName) {
            if (returnTypeName == null) {
                return new ByIndexOutParameterRegistration(outParameterSqlIndex, outParameterType);
            }
            return new ByIndexAndTypeNameOutParameterRegistration(outParameterSqlIndex, outParameterType, returnTypeName);
        }

        private static String getOutParameterName(Method method) {
            String outParameterName;
            OutParameter outParameter = method.getAnnotation(OutParameter.class);
            ReturnValue returnValue = method.getAnnotation(ReturnValue.class);
            if (outParameter != null) {
                if (returnValue != null) {
                    throw new IllegalArgumentException("method " + method + " needs to be annotated with only one of" + OutParameter.class + " or " + ReturnValue.class);
                }
                outParameterName = outParameter.name();
            } else {
                outParameterName = returnValue != null ? returnValue.name() : null;
            }
            if (outParameterName != null && outParameterName.isEmpty()) {
                return null;
            }
            return outParameterName;
        }

        private static int getOutParameterSqlIndex(Method method) {
            ReturnValue returnValue;
            InOutParameter inOutParameter;
            OutParameter outParameter = method.getAnnotation(OutParameter.class);
            if (ProcedureCaller.countNonNulls(outParameter, inOutParameter = method.getAnnotation(InOutParameter.class), returnValue = method.getAnnotation(ReturnValue.class)) > 1) {
                throw new IllegalArgumentException("method " + method + " needs to be annotated with only one of " + OutParameter.class + ", " + InOutParameter.class + " or " + ReturnValue.class);
            }
            int outParameterIndex = outParameter != null ? outParameter.index() : (inOutParameter != null ? inOutParameter.index() : (returnValue != null ? 1 : -1));
            if (outParameterIndex == -1) {
                if (outParameter != null || returnValue != null) {
                    return ProcedureCaller.getInputParameterCount(method) + 1;
                }
                if (inOutParameter != null) {
                    return ProcedureCaller.getInputParameterCount(method);
                }
            }
            return outParameterIndex;
        }

        private static int countNonNulls(Object o1, Object o2, Object o3) {
            int count = 0;
            if (o1 != null) {
                ++count;
            }
            if (o2 != null) {
                ++count;
            }
            if (o3 != null) {
                ++count;
            }
            return count;
        }

        private static String getReturnTypeName(Method method) {
            OutParameter outParameter = method.getAnnotation(OutParameter.class);
            ReturnValue returnValue = method.getAnnotation(ReturnValue.class);
            String typeName = outParameter != null ? outParameter.typeName() : (returnValue != null ? returnValue.typeName() : "");
            if ("".equals(typeName)) {
                return null;
            }
            return typeName;
        }

        private int getOutParameterType(Method method) {
            int outParameterType;
            Class<?> methodReturnType = method.getReturnType();
            if (methodReturnType == Void.TYPE) {
                return -1;
            }
            OutParameter outParameter = method.getAnnotation(OutParameter.class);
            ReturnValue returnValue = method.getAnnotation(ReturnValue.class);
            if (outParameter != null) {
                if (returnValue != null) {
                    throw new IllegalArgumentException("method " + method + " needs to be annotated with only one of" + OutParameter.class + " or " + ReturnValue.class);
                }
                outParameterType = outParameter.type();
            } else {
                outParameterType = returnValue != null ? returnValue.type() : Integer.MIN_VALUE;
            }
            if (outParameterType == Integer.MIN_VALUE) {
                if (methodReturnType == List.class) {
                    return 2012;
                }
                return this.typeMapper.mapToSqlType(methodReturnType);
            }
            return outParameterType;
        }

        private static int getFetchSize(Method method) {
            if (method.isAnnotationPresent(FetchSize.class)) {
                return method.getAnnotation(FetchSize.class).value();
            }
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass.isAnnotationPresent(FetchSize.class)) {
                return declaringClass.getAnnotation(FetchSize.class).value();
            }
            return 0;
        }

        private static Class<?> getListReturnTypeParamter(Method method) {
            Type genericReturnType = method.getGenericReturnType();
            if (genericReturnType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length != 1) {
                    throw new IllegalArgumentException("type arguments return type of " + method + " are missing");
                }
                Type actualTypeArgument = actualTypeArguments[0];
                if (!(actualTypeArgument instanceof Class)) {
                    throw new IllegalArgumentException("type arguments return type of " + method + " is not a class");
                }
                return (Class)actualTypeArgument;
            }
            throw new IllegalArgumentException("method " + method + " is missing type paramter for " + List.class);
        }

        static byte[] buildInParameterIndices(int parameterCount, Class<?>[] methodParameterTypes) {
            byte[] indices = new byte[parameterCount];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = ValueExtractorUtils.isAnyValueExtractor(methodParameterTypes[i]) ? (byte)0 : ByteUtils.toByte(i + 1);
            }
            return indices;
        }

        static byte[] buildInParameterIndices(int parameterCount, int outParameterIndex, Class<?>[] methodParameterTypes) {
            byte[] indices = new byte[parameterCount];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = ValueExtractorUtils.isAnyValueExtractor(methodParameterTypes[i]) ? (byte)0 : (outParameterIndex > i + 1 ? ByteUtils.toByte(i + 1) : ByteUtils.toByte(i + 2));
            }
            return indices;
        }

        private static int getValueExtractorIndex(Method method) {
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            for (int i = 0; i < methodParameterTypes.length; ++i) {
                Class<?> methodParameterType = methodParameterTypes[i];
                boolean valueExtractor = ValueExtractorUtils.isValueExtractor(methodParameterType);
                boolean numberedValueExtractor = ValueExtractorUtils.isNumberedValueExtractor(methodParameterType);
                if (valueExtractor && numberedValueExtractor) {
                    throw new IllegalArgumentException(methodParameterType + " is both: " + ValueExtractor.class + " and " + NumberedValueExtractor.class + " but should only be one");
                }
                if (!valueExtractor && !numberedValueExtractor) continue;
                return i;
            }
            return -1;
        }

        private static int getInputParameterCount(Method method) {
            int count = 0;
            for (Class<?> parameterType : method.getParameterTypes()) {
                if (ValueExtractorUtils.isAnyValueExtractor(parameterType)) continue;
                ++count;
            }
            return count;
        }

        private String buildCallString(Method method, String procedureName, int sqlInputParameterCount, boolean hasOutParameter) {
            String namespace = this.hasNamespace(method) ? this.extractsNamespace(method) : null;
            String schemaName = this.hasSchema(method) ? this.extractSchema(method) : null;
            boolean isFunction = ProcedureCaller.procedureHasReturnValue(method);
            if (isFunction) {
                return ProcedureCaller.buildQualifiedFunctionCallString(namespace, schemaName, procedureName, sqlInputParameterCount);
            }
            int sqlParameterCount = hasOutParameter && !ProcedureCaller.shareOutParameter(method) ? sqlInputParameterCount + 1 : sqlInputParameterCount;
            return ProcedureCaller.buildQualifiedProcedureCallString(namespace, schemaName, procedureName, sqlParameterCount);
        }

        private static boolean shareOutParameter(Method method) {
            return method.isAnnotationPresent(InOutParameter.class);
        }

        static String buildQualifiedProcedureCallString(String namespace, String schemaName, String functionName, int parameterCount) {
            return ProcedureCaller.buildCallString("{call ", namespace, schemaName, functionName, parameterCount);
        }

        static String buildQualifiedFunctionCallString(String namespace, String schemaName, String functionName, int parameterCount) {
            return ProcedureCaller.buildCallString("{ ? = call ", namespace, schemaName, functionName, parameterCount);
        }

        static String buildCallString(String prefix, String namespace, String schemaName, String functionName, int parameterCount) {
            int capacity = prefix.length();
            if (namespace != null) {
                capacity += namespace.length() + 1;
            }
            if (schemaName != null) {
                capacity += schemaName.length() + 1;
            }
            StringBuilder builder = new StringBuilder(capacity += functionName.length() + 1 + Math.max(parameterCount * 2 - 1, 0) + 2);
            builder.append(prefix);
            if (namespace != null) {
                builder.append(namespace);
                builder.append('.');
            }
            if (schemaName != null) {
                builder.append(schemaName);
                builder.append('.');
            }
            builder.append(functionName);
            builder.append('(');
            for (int i = 0; i < parameterCount; ++i) {
                if (i != 0) {
                    builder.append(',');
                }
                builder.append('?');
            }
            builder.append(")}");
            return builder.toString();
        }

        private static boolean procedureHasReturnValue(Method method) {
            return method.getAnnotation(ReturnValue.class) != null;
        }

        private static boolean wantsExceptionTranslation(Method method) {
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                if (exceptionType != SQLException.class) continue;
                return false;
            }
            return true;
        }

        private String extractProcedureName(Method method) {
            ProcedureName procedureName = method.getAnnotation(ProcedureName.class);
            if (procedureName != null) {
                return procedureName.value();
            }
            return this.procedureNamingStrategy.translateToDatabase(method.getName());
        }

        private boolean hasSchema(Method method) {
            return this.hasSchema || method.getDeclaringClass().isAnnotationPresent(Schema.class);
        }

        private String extractSchema(Method method) {
            String schema;
            Class<?> declaringClass = method.getDeclaringClass();
            Schema schemaAnnotation = declaringClass.getAnnotation(Schema.class);
            if (schemaAnnotation != null && !(schema = schemaAnnotation.value()).isEmpty()) {
                return schema;
            }
            return this.schemaNamingStrategy.translateToDatabase(declaringClass.getSimpleName());
        }

        private boolean hasNamespace(Method method) {
            return this.hasNamespace || method.getDeclaringClass().isAnnotationPresent(Schema.class);
        }

        private String extractsNamespace(Method method) {
            String namespace;
            Class<?> declaringClass = method.getDeclaringClass();
            Namespace namespaceAnnotation = declaringClass.getAnnotation(Namespace.class);
            if (namespaceAnnotation != null && !(namespace = namespaceAnnotation.value()).isEmpty()) {
                return namespace;
            }
            return this.namespaceNamingStrategy.translateToDatabase(declaringClass.getSimpleName());
        }
    }

    public static enum ParameterRegistration {
        INDEX_ONLY,
        NAME_ONLY,
        INDEX_AND_TYPE,
        NAME_AND_TYPE;

    }
}

