/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.OutParameterRegistration;
import com.github.marschall.storedprocedureproxy.ProcedureCallerFactory;
import com.github.marschall.storedprocedureproxy.ResultExtractor;
import com.github.marschall.storedprocedureproxy.ToStringUtils;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

final class ScalarResultExtractor
implements ResultExtractor {
    private final Class<?> returnType;

    ScalarResultExtractor(Class<?> returnType) {
        this.returnType = returnType;
    }

    @Override
    public Object extractResult(CallableStatement statement, OutParameterRegistration outParameterRegistration, Object[] args) throws SQLException {
        boolean hasResultSet = statement.execute();
        if (hasResultSet) {
            return this.readFromResultSet(statement, outParameterRegistration);
        }
        return this.readFromStatement(statement, outParameterRegistration);
    }

    private Object readFromStatement(CallableStatement statement, OutParameterRegistration outParameterRegistration) throws SQLException {
        return outParameterRegistration.getOutParamter(statement, this.returnType);
    }

    private Object readFromResultSet(CallableStatement statement, OutParameterRegistration outParameterRegistration) throws SQLException {
        Object last = null;
        int count = 0;
        try (ResultSet rs = statement.getResultSet();){
            while (rs.next()) {
                last = rs.getObject(1, this.returnType);
            }
        }
        if (++count != 1) {
            ProcedureCallerFactory.newIncorrectResultSizeException(1, count);
        }
        return this.returnType.cast(last);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + ToStringUtils.classNameToString(this.returnType) + ']';
    }
}

