/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.SQLExceptionAdapter;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;

final class SpringSQLExceptionAdapter
implements SQLExceptionAdapter {
    private final SQLExceptionTranslator translator;

    SpringSQLExceptionAdapter(SQLExceptionTranslator translator) {
        this.translator = translator;
    }

    SpringSQLExceptionAdapter(DataSource dataSource) {
        this((SQLExceptionTranslator)new SQLErrorCodeSQLExceptionTranslator(dataSource));
    }

    public DataAccessException translate(String procedureName, String sql, SQLException ex) {
        DataAccessException translated = this.translator.translate("calling procedure " + procedureName, sql, ex);
        if (translated != null) {
            return translated;
        }
        return new UncategorizedSQLException("failed to call procedure: " + procedureName, sql, ex);
    }
}

