/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy;

import com.github.marschall.storedprocedureproxy.OutParameterRegistration;
import com.github.marschall.storedprocedureproxy.ResultExtractor;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

final class VoidResultExtractor
implements ResultExtractor {
    static final ResultExtractor INSTANCE = new VoidResultExtractor();

    private VoidResultExtractor() {
    }

    @Override
    public Object extractResult(CallableStatement statement, OutParameterRegistration outParameterRegistration, Object[] args) throws SQLException {
        boolean hasResultSet = statement.execute();
        if (hasResultSet) {
            int count = 0;
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    ++count;
                }
            }
            if (count > 1) {
                throw new SQLException("expected at most 1 rows but got " + count);
            }
        }
        return null;
    }

    public String toString() {
        return "VoidResultExtractor";
    }
}

