/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.storedprocedureproxy.spi;

import com.github.marschall.storedprocedureproxy.spi.Capitalize;
import com.github.marschall.storedprocedureproxy.spi.Compund;
import com.github.marschall.storedprocedureproxy.spi.LowerCase;
import com.github.marschall.storedprocedureproxy.spi.Prefix;
import com.github.marschall.storedprocedureproxy.spi.SnakeCase;
import com.github.marschall.storedprocedureproxy.spi.UpperCase;
import com.github.marschall.storedprocedureproxy.spi.WithoutFirst;
import java.util.Objects;

@FunctionalInterface
public interface NamingStrategy {
    public static final NamingStrategy IDENTITY = s -> s;

    public String translateToDatabase(String var1);

    public static NamingStrategy upperCase() {
        return UpperCase.INSTANCE;
    }

    public static NamingStrategy lowerCase() {
        return LowerCase.INSTANCE;
    }

    public static NamingStrategy capitalize() {
        return Capitalize.INSTANCE;
    }

    public static NamingStrategy snakeCase() {
        return SnakeCase.INSTANCE;
    }

    public static NamingStrategy prefix(String prefix) {
        Objects.requireNonNull(prefix);
        return new Prefix(prefix);
    }

    public static NamingStrategy withoutFirst(int skipped) {
        return new WithoutFirst(skipped);
    }

    default public NamingStrategy then(NamingStrategy next) {
        Objects.requireNonNull(next);
        return new Compund(this, next);
    }

    default public NamingStrategy thenUpperCase() {
        return this.then(NamingStrategy.upperCase());
    }

    default public NamingStrategy thenLowerCase() {
        return this.then(NamingStrategy.lowerCase());
    }

    default public NamingStrategy thenCapitalize() {
        return this.then(NamingStrategy.capitalize());
    }

    default public NamingStrategy thenSnakeCase() {
        return this.then(NamingStrategy.snakeCase());
    }

    default public NamingStrategy thenPrefix(String prefix) {
        Objects.requireNonNull(prefix);
        return this.then(NamingStrategy.prefix(prefix));
    }

    default public NamingStrategy thenWithoutFirst(int skipped) {
        return this.then(NamingStrategy.withoutFirst(skipped));
    }
}

