/*
 * Decompiled with CFR 0.152.
 */
package com.github.mengxianun.encrypt;

import com.github.mengxianun.core.ResultStatus;
import com.github.mengxianun.core.exception.JsonDataException;
import com.github.mengxianun.core.utils.Utils;
import java.io.IOException;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AES {
    static final String KEY_ALGORITHM = "AES";
    static final String TRANSFORMATION = "AES/CBC/PKCS7Padding";
    static final String PROVIDER = "BC";
    static final String KEY = "key";
    static final String IV = "iv";
    static final String UID = "uid";

    private static String encrypt(String data, String keyStr, String ivStr) throws Exception {
        try {
            return new String(new Base64().encode(AES.doFinal(1, keyStr, ivStr, data.getBytes())));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(ResultStatus.JSON_FORMAT_ERROR.message());
        }
    }

    public static String decrypt(String data, String keyStr, String ivStr) throws Exception {
        try {
            byte[] encryptedData = new Base64().decode(data);
            return new String(AES.doFinal(2, keyStr, ivStr, encryptedData));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(ResultStatus.JSON_FORMAT_ERROR.message());
        }
    }

    private static byte[] getSecretKeyBytes(String keyStr) {
        int base;
        byte[] keyBytes = keyStr.getBytes();
        if (keyBytes.length % (base = 16) != 0) {
            int groups = keyBytes.length / base + (keyBytes.length % base != 0 ? 1 : 0);
            byte[] temp = new byte[groups * base];
            Arrays.fill(temp, (byte)0);
            System.arraycopy(keyBytes, 0, temp, 0, keyBytes.length);
            keyBytes = temp;
        }
        return keyBytes;
    }

    private static byte[] doFinal(int type, String keyStr, String ivStr, byte[] data) throws JsonDataException {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            SecretKeySpec key = new SecretKeySpec(AES.getSecretKeyBytes(keyStr), KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION, PROVIDER);
            cipher.init(type, (Key)key, new IvParameterSpec(ivStr.getBytes()));
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JsonDataException("");
        }
    }

    public static void main(String[] args) throws Exception {
        AES aes = new AES();
        String keys = "1530dfab199e4e24";
        String iv = "b97bcdb3ff1684aa";
        System.out.println(AES.encode(keys));
        System.out.println(AES.encode(iv));
        String content = "{'select': 'es.traffic','native': {'size': 0,'query': {'constant_score': {'filter': {'range': {'stat_time': {'gt': '2018-07-08 14:00:00','lt': '2018-07-08 15:00:00'}}}}},'aggs': {'top': {'terms': {'field': 'probe_name','order': {'total_traffic': 'desc'},'size': 3},'aggs': {'total_traffic': {'sum': {'script': {'source': 'doc.count_up.value + doc.count_down.value'}}},'interval_data': {'date_histogram': {'field': 'stat_time','interval': '5m','format': 'yyyy-MM-dd HH:mm:ss','min_doc_count': 0,'extended_bounds': {'min': '2018-07-08 14:00:00','max': '2018-07-08 14:55:00'}},'aggs': {'interval_traffic': {'sum': {'script': {'source': 'doc.count_up.value + doc.count_down.value'}}}}}}}}}}";
        String encrypt = AES.encrypt(content, keys, iv);
        System.out.println("\u52a0\u5bc6\u540e\u7684\u5185\u5bb9\uff1a" + encrypt);
        String decrypt = AES.decrypt(encrypt, keys, iv);
        System.out.println("\u89e3\u5bc6\u540e\u7684\u5185\u5bb9\uff1a" + decrypt);
    }

    public static String getUUID() {
        return Utils.getUUID();
    }

    public static String[] getKeyAndIV() {
        String str = AES.getUUID();
        System.out.println("UUID------->" + str);
        return new String[]{str.substring(0, 16), str.substring(16)};
    }

    private static String encode(String str) {
        return new String(new Base64().encode(str.getBytes()));
    }

    private static String decode(String str) throws IOException {
        return new String(new Base64().decode(str));
    }
}

