/*
 * Decompiled with CFR 0.152.
 */
package com.github.mengxianun.encrypt;

import com.github.mengxianun.encrypt.SecretKeySingleEntity;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RefreshSecretKeyTask
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static volatile RefreshSecretKeyTask task;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private Future createFuture = null;
    private Future destroyFuture = null;
    private int periodTime = 5;
    private int delayTime = 6;

    private RefreshSecretKeyTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RefreshSecretKeyTask getInstance() {
        if (task != null) return task;
        Class<RefreshSecretKeyTask> clazz = RefreshSecretKeyTask.class;
        synchronized (RefreshSecretKeyTask.class) {
            if (task != null) return task;
            task = new RefreshSecretKeyTask();
            // ** MonitorExit[var0] (shouldn't be in output)
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static RefreshSecretKeyTask getInstance(Integer aliveTimeMinute, Integer destroyTimeMinute) {
        if (task == null) {
            Class<RefreshSecretKeyTask> clazz = RefreshSecretKeyTask.class;
            // MONITORENTER : com.github.mengxianun.encrypt.RefreshSecretKeyTask.class
            if (task == null) {
                task = new RefreshSecretKeyTask();
            }
            // MONITOREXIT : clazz
        }
        task.setAliveTime(aliveTimeMinute);
        task.setDestroyTime(destroyTimeMinute);
        return task;
    }

    public void setAliveTime(Integer aliveTimeMinute) {
        if (aliveTimeMinute != null && aliveTimeMinute > 0) {
            this.periodTime = aliveTimeMinute;
        }
    }

    public void setDestroyTime(Integer destroyTimeMinute) {
        if (destroyTimeMinute != null && destroyTimeMinute > 0) {
            this.delayTime = destroyTimeMinute;
        }
    }

    public void start() {
        this.stop();
        Runnable createHandler = new Runnable(){

            @Override
            public void run() {
                SecretKeySingleEntity entity = SecretKeySingleEntity.getInstance();
                entity.createSecretKey(RefreshSecretKeyTask.this.delayTime, RefreshSecretKeyTask.this.periodTime);
            }
        };
        this.createFuture = this.scheduler.scheduleAtFixedRate(createHandler, 0L, this.periodTime * 60, TimeUnit.SECONDS);
        Runnable destroyHandler = new Runnable(){

            @Override
            public void run() {
                SecretKeySingleEntity entity = SecretKeySingleEntity.getInstance();
                entity.destroyOldestSecretKey();
            }
        };
        this.destroyFuture = this.scheduler.scheduleAtFixedRate(destroyHandler, this.delayTime * 60, this.periodTime * 60, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.createFuture != null && !this.createFuture.isCancelled()) {
            this.createFuture.cancel(true);
            this.createFuture = null;
        }
        if (this.destroyFuture != null && !this.destroyFuture.isCancelled()) {
            this.destroyFuture.cancel(true);
            this.destroyFuture = null;
        }
    }
}

