/*
 * Decompiled with CFR 0.152.
 */
package com.github.mengxianun.encrypt;

import com.github.mengxianun.encrypt.AES;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SecretKeySingleEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static volatile SecretKeySingleEntity entity;
    private static ConcurrentHashMap<Long, Map<String, Object>> secretKeyMap;
    private static ConcurrentHashMap<Long, Long> nextTimeMap;
    private static Long bufferTime;

    private SecretKeySingleEntity() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecretKeySingleEntity getInstance() {
        if (entity != null) return entity;
        Class<SecretKeySingleEntity> clazz = SecretKeySingleEntity.class;
        synchronized (SecretKeySingleEntity.class) {
            if (entity != null) return entity;
            entity = new SecretKeySingleEntity();
            // ** MonitorExit[var0] (shouldn't be in output)
            return entity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSecretKey(int destroyTimeMinute, int createTimeMinute) {
        SecretKeySingleEntity secretKeySingleEntity = entity;
        synchronized (secretKeySingleEntity) {
            String[] keyAndIV = AES.getKeyAndIV();
            String key = keyAndIV[0];
            String iv = keyAndIV[1];
            String uid = AES.getUUID();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("key", key);
            map.put("iv", iv);
            map.put("uid", uid);
            secretKeyMap.put(this.deathTimeL(destroyTimeMinute), map);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss:SSS");
            System.out.println("===============\u521a\u521a\u751f\u6210\u4e86\u4e00\u6761\u5bc6\u94a5=================" + format.format(Calendar.getInstance().getTimeInMillis()));
            for (Map.Entry<Long, Map<String, Object>> entry : secretKeyMap.entrySet()) {
                System.out.println("\u9884\u8ba1\u6b7b\u4ea1\u65f6\u95f4 : " + format.format(entry.getKey()));
                System.out.println("KEY        : " + entry.getValue().get("key"));
                System.out.println("IV         : " + entry.getValue().get("iv"));
                System.out.println("UID        : " + entry.getValue().get("uid"));
                System.out.println("---------------------------------------------");
            }
            System.out.println("================================================");
            bufferTime = (long)((destroyTimeMinute - createTimeMinute) * 60) * 1000L;
        }
    }

    private long deathTimeL(int destroyTimeSeconds) {
        Calendar cal = Calendar.getInstance();
        cal.add(12, destroyTimeSeconds);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyOldestSecretKey() {
        SecretKeySingleEntity secretKeySingleEntity = entity;
        synchronized (secretKeySingleEntity) {
            Calendar now = Calendar.getInstance();
            for (Map.Entry<Long, Map<String, Object>> entry : secretKeyMap.entrySet()) {
                if (entry.getKey() > now.getTimeInMillis()) continue;
                secretKeyMap.remove(entry.getKey());
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            System.out.println("===============\u521a\u521a\u6267\u884c\u4e86\u9500\u6bc1\u5bc6\u94a5=================" + format.format(Calendar.getInstance().getTimeInMillis()));
            for (Map.Entry<Long, Map<String, Object>> entry : secretKeyMap.entrySet()) {
                System.out.println("\u9884\u8ba1\u6b7b\u4ea1\u65f6\u95f4: " + format.format(entry.getKey()));
                System.out.println("KEY       :" + entry.getValue().get("key"));
                System.out.println("IV        :" + entry.getValue().get("iv"));
                System.out.println("UID       :" + entry.getValue().get("uid"));
                System.out.println("-------------------------------------------");
            }
            System.out.println("================================================");
        }
    }

    public String getKey(String uid) {
        return this.getKey(uid, "key");
    }

    public String getIV(String uid) {
        return this.getKey(uid, "iv");
    }

    public String getKey(String uid, String objectKey) {
        for (Map.Entry<Long, Map<String, Object>> entry : secretKeyMap.entrySet()) {
            if (!entry.getValue().get("uid").equals(uid)) continue;
            return entry.getValue().get(objectKey).toString();
        }
        return null;
    }

    protected Map<Long, Map<String, Object>> getAllInfo() {
        return secretKeyMap;
    }

    public List<String> getAliveKeys() {
        return this.getObjectArray("key");
    }

    public List<String> getAliveUids() {
        return this.getObjectArray("uid");
    }

    public List<String> getAliveIVs() {
        return this.getObjectArray("iv");
    }

    public List<String> getObjectArray(String objectKey) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<Long, Map<String, Object>> entry : secretKeyMap.entrySet()) {
            list.add(entry.getValue().get(objectKey).toString());
        }
        return list;
    }

    public Map<String, Object> getSecretKeyAndIv(String uid) {
        for (Map.Entry<Long, Map<String, Object>> entry : secretKeyMap.entrySet()) {
            if (!entry.getValue().get("uid").equals(uid)) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<String, Object> getLatestInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long lastestTime = 0L;
        for (Map.Entry<Long, Map<String, Object>> entry : secretKeyMap.entrySet()) {
            if (entry.getKey() <= lastestTime) continue;
            lastestTime = entry.getKey();
        }
        if (secretKeyMap.get(lastestTime) != null) {
            map.putAll(secretKeyMap.get(lastestTime));
            map.put("deathTime", lastestTime - Calendar.getInstance().getTimeInMillis() - bufferTime + 2000L);
        }
        return map;
    }

    static {
        secretKeyMap = new ConcurrentHashMap();
        nextTimeMap = new ConcurrentHashMap();
        bufferTime = 0L;
    }
}

