/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.cell;

import bad.robot.excel.cell.StyledCell;
import bad.robot.excel.column.ColumnIndex;
import bad.robot.excel.style.NoStyle;
import bad.robot.excel.style.Style;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;

public class ErrorCell
extends StyledCell {
    private final Byte errorCode;

    public ErrorCell(Byte text) {
        this(text, new NoStyle());
    }

    public ErrorCell(Byte text, Style style) {
        super(style);
        this.errorCode = text;
    }

    @Override
    public void addTo(Row row, ColumnIndex column, Workbook workbook) {
        Cell cell = row.createCell(((Integer)column.value()).intValue(), 5);
        this.update(cell, workbook);
    }

    @Override
    public void update(Cell cell, Workbook workbook) {
        this.getStyle().applyTo(cell, workbook);
        cell.setCellErrorValue(this.errorCode.byteValue());
    }

    public String toString() {
        return String.format("Error:%s", this.errorCode);
    }
}

