/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.cell;

import bad.robot.excel.cell.Formula;
import bad.robot.excel.cell.StyledCell;
import bad.robot.excel.column.ColumnIndex;
import bad.robot.excel.style.NoStyle;
import bad.robot.excel.style.Style;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;

public class FormulaCell
extends StyledCell {
    private final String formula;

    public FormulaCell(String formula) {
        this(formula, new NoStyle());
    }

    public FormulaCell(Formula formula) {
        this((String)formula.value());
    }

    public FormulaCell(String text, Style style) {
        super(style);
        this.formula = text;
    }

    @Override
    public void addTo(Row row, ColumnIndex column, Workbook workbook) {
        Cell cell = row.createCell(((Integer)column.value()).intValue(), 2);
        this.update(cell, workbook);
    }

    @Override
    public void update(Cell cell, Workbook workbook) {
        this.getStyle().applyTo(cell, workbook);
        cell.setCellFormula(this.formula);
    }

    public String toString() {
        return String.format("Formula:%s", this.formula);
    }
}

