/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.cell;

import bad.robot.excel.cell.Hyperlink;
import bad.robot.excel.cell.StyledCell;
import bad.robot.excel.column.ColumnIndex;
import bad.robot.excel.style.NoStyle;
import bad.robot.excel.style.Style;
import java.net.URL;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;

public class HyperlinkCell
extends StyledCell {
    private final String text;
    private final URL link;

    public HyperlinkCell(String text, URL link) {
        this(text, link, new NoStyle());
    }

    public HyperlinkCell(Hyperlink link) {
        this(link.text(), (URL)link.value());
    }

    public HyperlinkCell(String text, URL link, Style style) {
        super(style);
        this.text = text;
        this.link = link;
    }

    @Override
    public void addTo(Row row, ColumnIndex column, Workbook workbook) {
        Cell cell = row.createCell(((Integer)column.value()).intValue(), 1);
        this.update(cell, workbook);
    }

    @Override
    public void update(Cell cell, Workbook workbook) {
        this.getStyle().applyTo(cell, workbook);
        cell.setCellValue(this.text);
        cell.setHyperlink(this.createHyperlink(workbook));
    }

    public String toString() {
        return String.format("<a href='%s'>%s</a>", this.link, this.text);
    }

    private org.apache.poi.ss.usermodel.Hyperlink createHyperlink(Workbook workbook) {
        org.apache.poi.ss.usermodel.Hyperlink hyperlink = workbook.getCreationHelper().createHyperlink(1);
        hyperlink.setAddress(this.link.toExternalForm());
        return hyperlink;
    }
}

