/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.matchers;

import bad.robot.excel.PoiToExcelCoercions;
import bad.robot.excel.matchers.CellType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class CellInRowMatcher
extends TypeSafeDiagnosingMatcher<Row> {
    private final Sheet sheet;
    private final bad.robot.excel.cell.Cell expected;
    private final int columnIndex;
    private final String coordinate;

    private CellInRowMatcher(Sheet sheet, Cell expectedPoi) {
        this.sheet = sheet;
        this.expected = CellType.adaptPoi(expectedPoi);
        this.coordinate = PoiToExcelCoercions.asExcelCoordinate(expectedPoi);
        this.columnIndex = expectedPoi.getColumnIndex();
    }

    public static CellInRowMatcher hasSameCell(Sheet sheet, Cell expected) {
        return new CellInRowMatcher(sheet, expected);
    }

    protected boolean matchesSafely(Row row, Description mismatch) {
        bad.robot.excel.cell.Cell actual = CellType.adaptPoi(row.getCell(this.columnIndex));
        if (!this.expected.equals(actual)) {
            mismatch.appendText("cell at ").appendValue((Object)this.coordinate).appendText(" contained ").appendValue((Object)actual).appendText(" expected ").appendValue((Object)this.expected).appendText(" sheet ").appendValue((Object)this.sheet.getSheetName());
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("equality of cell ").appendValue((Object)this.coordinate);
    }
}

