/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.matchers;

import bad.robot.excel.PoiToExcelCoercions;
import org.apache.poi.ss.usermodel.Row;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class CellNumberMatcher
extends TypeSafeDiagnosingMatcher<Row> {
    private final Row expected;

    public static CellNumberMatcher hasSameNumberOfCellsAs(Row expected) {
        return new CellNumberMatcher(expected);
    }

    private CellNumberMatcher(Row expected) {
        this.expected = expected;
    }

    protected boolean matchesSafely(Row actual, Description mismatch) {
        if (this.expected.getLastCellNum() != actual.getLastCellNum()) {
            mismatch.appendText("got ").appendValue((Object)CellNumberMatcher.numberOfCellsIn(actual)).appendText(" cell(s) on row ").appendValue((Object)PoiToExcelCoercions.asExcelRow(this.expected)).appendText(" expected ").appendValue((Object)CellNumberMatcher.numberOfCellsIn(this.expected)).appendText(" sheet ").appendValue((Object)this.expected.getSheet().getSheetName());
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendValue((Object)CellNumberMatcher.numberOfCellsIn(this.expected)).appendText(" cell(s) on row ").appendValue((Object)PoiToExcelCoercions.asExcelRow(this.expected)).appendText(" sheet ").appendValue((Object)this.expected.getSheet().getSheetName());
    }

    private static int numberOfCellsIn(Row row) {
        return row.getLastCellNum();
    }
}

