/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.matchers;

import bad.robot.excel.matchers.Mismatches;
import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class CompositeMatcher<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final Iterable<Matcher<T>> matchers;

    @Factory
    static <T> CompositeMatcher<T> allOf(Iterable<Matcher<T>> matchers) {
        return new CompositeMatcher<T>(matchers);
    }

    @Factory
    static <T> TypeSafeDiagnosingMatcher<T> allOf(Matcher<T> ... matchers) {
        return CompositeMatcher.allOf(Arrays.asList(matchers));
    }

    private CompositeMatcher(Iterable<Matcher<T>> matchers) {
        this.matchers = matchers;
    }

    protected boolean matchesSafely(T actual, Description mismatch) {
        Mismatches<T> mismatches = new Mismatches<T>();
        if (mismatches.discover(actual, this.matchers)) {
            mismatches.describeTo(mismatch, actual);
        }
        return !mismatches.found();
    }

    public void describeTo(Description description) {
        description.appendList("", " ", "", this.matchers);
    }
}

