/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.matchers;

import bad.robot.excel.matchers.CompositeMatcher;
import bad.robot.excel.matchers.RowInSheetMatcher;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class RowsMatcher
extends TypeSafeDiagnosingMatcher<Sheet> {
    private final Sheet expected;
    private final List<Matcher<Sheet>> rowsOnSheet;

    public static RowsMatcher hasSameRowsAs(Sheet expected) {
        return new RowsMatcher(expected);
    }

    private RowsMatcher(Sheet expected) {
        this.expected = expected;
        this.rowsOnSheet = RowsMatcher.createRowMatchers(expected);
    }

    protected boolean matchesSafely(Sheet actual, Description mismatch) {
        return CompositeMatcher.allOf(this.rowsOnSheet).matchesSafely(actual, mismatch);
    }

    public void describeTo(Description description) {
        description.appendText("equality on all rows in ").appendValue((Object)this.expected.getSheetName());
    }

    private static List<Matcher<Sheet>> createRowMatchers(Sheet sheet) {
        ArrayList<Matcher<Sheet>> matchers = new ArrayList<Matcher<Sheet>>();
        for (Row expected : sheet) {
            matchers.add((Matcher<Sheet>)RowInSheetMatcher.hasSameRow(expected));
        }
        return matchers;
    }
}

