/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.matchers;

import bad.robot.excel.matchers.CompositeMatcher;
import bad.robot.excel.matchers.SheetNameMatcher;
import bad.robot.excel.matchers.SheetNumberMatcher;
import org.apache.poi.ss.usermodel.Workbook;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class SheetMatcher
extends TypeSafeDiagnosingMatcher<Workbook> {
    private final Matcher<Workbook> matchers;

    public static SheetMatcher hasSameSheetsAs(Workbook expected) {
        return new SheetMatcher(expected);
    }

    private SheetMatcher(Workbook expected) {
        SheetNumberMatcher numberOfSheets = SheetNumberMatcher.hasSameNumberOfSheetsAs(expected);
        SheetNameMatcher namesOfSheets = SheetNameMatcher.containsSameNamedSheetsAs(expected);
        this.matchers = CompositeMatcher.allOf(new Matcher[]{numberOfSheets, namesOfSheets});
    }

    protected boolean matchesSafely(Workbook actual, Description mismatch) {
        boolean match = this.matchers.matches((Object)actual);
        if (!match) {
            this.matchers.describeMismatch((Object)actual, mismatch);
        }
        return match;
    }

    public void describeTo(Description description) {
        this.matchers.describeTo(description);
    }
}

