/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.row;

import bad.robot.excel.cell.Cell;
import bad.robot.excel.column.ColumnIndex;
import bad.robot.excel.row.RowIndex;
import bad.robot.excel.sheet.SheetIndex;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class Row {
    private static final int shiftDownAmount = 1;
    private final Map<ColumnIndex, Cell> cells = new HashMap<ColumnIndex, Cell>();

    public Row(Map<ColumnIndex, Cell> cells) {
        this.cells.putAll(cells);
    }

    public void insertAt(Workbook workbook, SheetIndex sheetIndex, RowIndex rowIndex) {
        Sheet sheet = workbook.getSheetAt(((Integer)sheetIndex.value()).intValue());
        sheet.shiftRows(((Integer)rowIndex.value()).intValue(), sheet.getLastRowNum(), 1);
        org.apache.poi.ss.usermodel.Row row = sheet.createRow(((Integer)rowIndex.value()).intValue());
        this.copyCellsTo(row, workbook);
    }

    public void appendTo(Workbook workbook, SheetIndex index) {
        Sheet sheet = workbook.getSheetAt(((Integer)index.value()).intValue());
        org.apache.poi.ss.usermodel.Row row = Row.createRow(sheet);
        this.copyCellsTo(row, workbook);
    }

    private void copyCellsTo(org.apache.poi.ss.usermodel.Row row, Workbook workbook) {
        for (ColumnIndex index : this.cells.keySet()) {
            Cell cellToInsert = this.cells.get(index);
            cellToInsert.addTo(row, index, workbook);
        }
    }

    private static org.apache.poi.ss.usermodel.Row createRow(Sheet sheet) {
        if (sheet.getPhysicalNumberOfRows() == 0) {
            return sheet.createRow(0);
        }
        return sheet.createRow(sheet.getLastRowNum() + 1);
    }
}

