/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.style;

import bad.robot.excel.cell.DataFormat;
import bad.robot.excel.style.Alignment;
import bad.robot.excel.style.AlignmentStyle;
import bad.robot.excel.style.Border;
import bad.robot.excel.style.BorderStyle;
import bad.robot.excel.style.ClonedStyleFactory;
import bad.robot.excel.style.Colour;
import bad.robot.excel.style.Fill;
import bad.robot.excel.style.FontColour;
import bad.robot.excel.style.FontSize;
import bad.robot.excel.style.Style;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;

public class ReplaceExistingStyle
implements Style {
    private final DataFormat format;
    private final Alignment alignment;
    private final FontSize fontSize;
    private final FontColour fontColour;
    private final Fill fill;
    private final Border border;

    ReplaceExistingStyle(Border border, DataFormat format, Alignment alignment, FontSize fontSize, FontColour fontColour, Fill fill) {
        this.border = border;
        this.format = format;
        this.alignment = alignment;
        this.fontSize = fontSize;
        this.fontColour = fontColour;
        this.fill = fill;
    }

    @Override
    public void applyTo(Cell cell, Workbook workbook) {
        CellStyle style = ClonedStyleFactory.newStyleBasedOn(cell).create(workbook);
        this.applyBorderTo(style);
        this.applyFillTo(style);
        this.applyAlignmentTo(style);
        this.applyDataFormatTo(style, workbook);
        this.applyFontTo(style, workbook);
        cell.setCellStyle(style);
    }

    private void applyBorderTo(CellStyle style) {
        if (this.border != null) {
            style.setBorderBottom(((BorderStyle)((Object)this.border.getBottom().value())).getPoiStyle().shortValue());
            style.setBorderTop(((BorderStyle)((Object)this.border.getTop().value())).getPoiStyle().shortValue());
            style.setBorderRight(((BorderStyle)((Object)this.border.getRight().value())).getPoiStyle().shortValue());
            style.setBorderLeft(((BorderStyle)((Object)this.border.getLeft().value())).getPoiStyle().shortValue());
        }
    }

    private void applyFillTo(CellStyle style) {
        if (this.fill != null) {
            style.setFillPattern((short)1);
            style.setFillForegroundColor(((Colour)((Object)this.fill.getForegroundColour().value())).getPoiStyle());
        }
    }

    private void applyAlignmentTo(CellStyle style) {
        if (this.alignment != null) {
            style.setAlignment(((AlignmentStyle)((Object)this.alignment.value())).getPoiStyle().shortValue());
        }
    }

    private void applyDataFormatTo(CellStyle style, Workbook workbook) {
        if (this.format != null) {
            style.setDataFormat(workbook.createDataFormat().getFormat((String)this.format.value()));
        }
    }

    private void applyFontTo(CellStyle style, Workbook workbook) {
        if (this.fontSize != null) {
            Font font = workbook.createFont();
            font.setFontHeightInPoints(((Short)this.fontSize.value()).shortValue());
            font.setColor(((Colour)((Object)this.fontColour.value())).getPoiStyle());
            style.setFont(font);
        } else {
            Font existing = workbook.getFontAt(style.getFontIndex());
            existing.setColor(((Colour)((Object)this.fontColour.value())).getPoiStyle());
            style.setFont(existing);
        }
    }
}

