/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.workbook;

import bad.robot.excel.workbook.Readable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class PoiWorkbookReader
implements Readable<Workbook> {
    @Override
    public Workbook read(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        return this.read(stream);
    }

    @Override
    public Workbook read(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("stream was null, could not load the workbook");
        }
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)stream);
            return workbook;
        }
        catch (InvalidFormatException e) {
            throw new IOException(e);
        }
        finally {
            stream.close();
        }
    }
}

