/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.workbook;

import bad.robot.excel.workbook.Writable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;

public class PoiWorkbookWriter
implements Writable {
    private final Workbook workbook;

    public PoiWorkbookWriter(Workbook workbook) {
        this.workbook = workbook;
    }

    @Override
    public void writeTo(OutputStream stream) {
        try {
            this.workbook.write(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveAs(File file) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            this.workbook.write((OutputStream)stream);
            stream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveAsTemporaryFile(String filenameExcludingExtension) {
        String extension = this.workbook instanceof HSSFWorkbook ? ".xls" : ".xlsx";
        try {
            File file = File.createTempFile(filenameExcludingExtension, extension);
            this.saveAs(file);
            System.out.printf("saved %s: %s%n", extension, file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("failed to save %s: %s.%s", extension, filenameExcludingExtension, extension), e);
        }
    }
}

