/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.caching;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public class CachingDelegateEncryptablePropertySource<T>
extends PropertySource<T>
implements EncryptablePropertySource<T> {
    private final PropertySource<T> delegate;
    private final EncryptablePropertyResolver resolver;
    private final EncryptablePropertyFilter filter;
    private final Map<String, Object> cache;

    public CachingDelegateEncryptablePropertySource(PropertySource<T> delegate, EncryptablePropertyResolver resolver, EncryptablePropertyFilter filter) {
        super(delegate.getName(), delegate.getSource());
        Assert.notNull(delegate, (String)"PropertySource delegate cannot be null");
        Assert.notNull((Object)resolver, (String)"EncryptablePropertyResolver cannot be null");
        Assert.notNull((Object)filter, (String)"EncryptablePropertyFilter cannot be null");
        this.delegate = delegate;
        this.resolver = resolver;
        this.filter = filter;
        this.cache = new HashMap<String, Object>();
    }

    @Override
    public PropertySource<T> getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String name) {
        if (this.cache.containsKey(name)) {
            return this.cache.get(name);
        }
        CachingDelegateEncryptablePropertySource cachingDelegateEncryptablePropertySource = this;
        synchronized (cachingDelegateEncryptablePropertySource) {
            Object resolved;
            if (!this.cache.containsKey(name) && (resolved = this.getProperty(this.resolver, this.filter, this.delegate, name)) != null) {
                this.cache.put(name, resolved);
            }
            return this.cache.get(name);
        }
    }

    @Override
    public void refresh() {
        this.cache.clear();
    }
}

