/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.MidiUtils;

public abstract class MidiMessage
implements Cloneable {
    protected byte[] data;
    protected int length;

    protected MidiMessage(byte[] abData) {
        if (abData != null) {
            this.copyToData(abData, abData.length);
        }
    }

    protected void setMessage(byte[] abData, int nLength) throws InvalidMidiDataException {
        this.copyToData(abData, nLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToData(byte[] abData, int nLength) {
        MidiMessage midiMessage = this;
        synchronized (midiMessage) {
            this.data = new byte[nLength];
            System.arraycopy(abData, 0, this.data, 0, nLength);
            this.length = nLength;
        }
    }

    public byte[] getMessage() {
        byte[] abData = new byte[this.length];
        System.arraycopy(this.data, 0, abData, 0, this.length);
        return abData;
    }

    public int getStatus() {
        int nStatus = MidiUtils.getUnsignedInteger(this.data[0]);
        return nStatus;
    }

    public int getLength() {
        return this.length;
    }

    public abstract Object clone();

    private void outputData() {
        String strMessage = "MidiMessage.outputData(): data: [";
        for (int i = 0; i < this.data.length; ++i) {
            strMessage = strMessage + this.data[i] + ", ";
        }
        strMessage = strMessage + "]";
        TDebug.out(strMessage);
    }
}

