/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.appserver.tools.jaxrpc.common;

import com.ctc.wstx.evt.WstxEventReader;
import com.ctc.wstx.stax.WstxInputFactory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ibm.websphere.appserver.tools.jaxrpc.common.ArchiveResources;
import com.ibm.websphere.appserver.tools.jaxrpc.common.CommonLoggerI;
import com.ibm.websphere.appserver.tools.jaxrpc.common.CommonLoggerImpl;
import com.ibm.websphere.appserver.tools.jaxrpc.common.PredeployUtil;
import com.ibm.websphere.appserver.tools.jaxrpc.common.WSDLValidationResult;
import com.ibm.websphere.appserver.tools.jaxrpc.common.WSDLValidationResults;
import com.ibm.websphere.appserver.tools.jaxrpc.common.WsdlDocumentElement;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.WSDLResource;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.XMLEvent;

public class ValidateWSDLUtil {
    static CommonLoggerI log;
    static final String SOAP_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/soap/";
    static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    static final String MIME_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/mime/";
    static final String XML_SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String APACHE_SOAP_NAMESPACE = "http://xml.apache.org/xml-soap";
    public static final String SOAP_ENCODING_NAMESPACE = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String WEBSPHERE_WEBSERVICES_NAMESPACE = "http://websphere.ibm.com/webservices/";
    public static final String IBM_TWAS_NAMESPACE = "http://www.ibm.com/ns/2003/06/wsdl/mp";
    static final List<String> ELEMENTS_TO_CHECK_FOR_RPC_ENCODING;
    static final Pattern VALID_MIME_TYPES;
    static final List<WsdlDocumentElement> WSDL_PART_HIERARCHY;
    static final List<WsdlDocumentElement> MIME_PART_HIERARCHY;
    static final List<WsdlDocumentElement> MIME_PART_FULL_HIERARCHY;
    static final Set<String> XSD_GCAL_TYPES;

    public static void setLogger(CommonLoggerI logger) {
        log = logger;
        PredeployUtil.setLogger(logger);
    }

    public static WSDLValidationResult wsdlScanner(URL wsdlURL) throws XMLStreamException {
        WstxInputFactory xmlif = (WstxInputFactory)WstxInputFactory.newInstance();
        WstxEventReader xmler = (WstxEventReader)xmlif.createXMLEventReader(wsdlURL);
        return ValidateWSDLUtil.wsdlScanner(xmler, null);
    }

    public static WSDLValidationResult wsdlScanner(File wsdlFile) throws XMLStreamException {
        WstxInputFactory xmlif = (WstxInputFactory)WstxInputFactory.newInstance();
        WstxEventReader xmler = (WstxEventReader)xmlif.createXMLEventReader(wsdlFile);
        return ValidateWSDLUtil.wsdlScanner(xmler, null);
    }

    public static WSDLValidationResult wsdlScanner(WSDLResource wsdl) throws XMLStreamException {
        WstxInputFactory xmlif = (WstxInputFactory)WstxInputFactory.newInstance();
        WstxEventReader xmler = wsdl.isFile() ? (WstxEventReader)xmlif.createXMLEventReader(wsdl.getWsdlFile()) : (WstxEventReader)xmlif.createXMLEventReader(wsdl.getWsdlUrl());
        WSDLValidationResult result = ValidateWSDLUtil.wsdlScanner(xmler, wsdl);
        result.setWsdlPath(wsdl.getWsdlPath());
        return result;
    }

    public static String wsdlScanner(File archiveFile, File outputDir) throws XMLStreamException, Exception {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (log == null) {
            ValidateWSDLUtil.setLogger(new CommonLoggerImpl());
        }
        ArchiveResources ar = PredeployUtil.collectResourcesFromArchive(archiveFile, outputDir, false, null, false);
        WSDLValidationResults results = new WSDLValidationResults(archiveFile, ar.getWarnMsgList(), ar.getErrMsgList());
        if (ar.getXmlResources().isAllXmlValid()) {
            for (WSDLResource wResource : ar.getWsdlResources().getAllWsdls()) {
                results.addWSDLValidationResult(ValidateWSDLUtil.wsdlScanner(wResource));
            }
        }
        if (results.getTotalCount() == 0) {
            ar.logWarn(MessageFormat.format("No WSDLs were scanned in archive {0}.", archiveFile.getCanonicalPath()));
        }
        return gson.toJson(results);
    }

    private static WSDLValidationResult wsdlScanner(WstxEventReader xmler, WSDLResource wsdl) throws XMLStreamException {
        WSDLValidationResult result = new WSDLValidationResult(log);
        HashSet<String> partNames = wsdl == null ? new HashSet() : wsdl.getXsdTypeNames().keySet();
        Stack<WstxEventReader> eventReaders = new Stack<WstxEventReader>();
        eventReaders.push(xmler);
        while (!eventReaders.empty()) {
            XMLEvent event;
            WstxEventReader currentXmler = (WstxEventReader)eventReaders.pop();
            WsdlDocumentElement parent = null;
            WsdlDocumentElement prevStartElem = null;
            while (currentXmler.hasNextEvent() && (event = currentXmler.nextEvent()) != null && !event.isEndDocument()) {
                if (event.isStartElement()) {
                    WsdlDocumentElement wde = new WsdlDocumentElement(event);
                    wde.setParent(parent);
                    ValidateWSDLUtil.checkForExternalConfig(wde, result, eventReaders);
                    ValidateWSDLUtil.checkNamespace(wde, result);
                    ValidateWSDLUtil.collectSoapAddress(wde, result);
                    ValidateWSDLUtil.isSoapOverJmsTransportDefined(wde, result);
                    ValidateWSDLUtil.isRpcEncodedStyle(wde, result);
                    ValidateWSDLUtil.checkElementComplexType(wde, result);
                    ValidateWSDLUtil.collectSchemaElement(wde, result);
                    ValidateWSDLUtil.collectMessageElement(wde, result);
                    ValidateWSDLUtil.collectWsdlPart(wde, result);
                    ValidateWSDLUtil.collectMimePart(wde, result);
                    ValidateWSDLUtil.collectXsdType(wde, partNames, result);
                    parent = wde;
                    prevStartElem = wde;
                    continue;
                }
                if (!event.isEndElement()) continue;
                ValidateWSDLUtil.collectInnerElement(event, prevStartElem, result);
                if (parent == null || !parent.hasParent()) continue;
                parent = parent.getParent();
            }
            currentXmler.close();
        }
        ValidateWSDLUtil.validateMime(result);
        ValidateWSDLUtil.verifyValidPort(result);
        return result;
    }

    private static void collectXsdType(WsdlDocumentElement wde, Set<String> partNames, WSDLValidationResult result) {
        if (wde.ofElementType("element")) {
            String[] split;
            String xsdType;
            String varName = wde.getAttributeValue("name");
            String type = wde.getAttributeValue("type");
            if (varName != null && type != null && (XSD_GCAL_TYPES.contains(xsdType = (split = type.split(":"))[split.length - 1]) || partNames.contains(varName))) {
                result.addVarToXsdType(varName, xsdType);
            }
        }
    }

    private static void checkNamespace(WsdlDocumentElement wde, WSDLValidationResult result) {
        ValidateWSDLUtil.checkUnsupportedNamespace(wde, result);
        if (wde.ofElementTypes("definitions")) {
            String namespace = wde.getAttributeValue("targetNamespace");
            result.setTargetNamespace(namespace);
        }
    }

    private static void checkUnsupportedNamespace(WsdlDocumentElement wde, WSDLValidationResult result) {
        if (wde.ofElementTypes("schema", "definitions", "import")) {
            if (!result.isUnsupportedApacheSoapNS()) {
                result.setUnsupportedApacheSoapNS(ValidateWSDLUtil.hasNamespace(wde, APACHE_SOAP_NAMESPACE));
                if (result.isUnsupportedApacheSoapNS()) {
                    result.logError("This WSDL uses namespace http://xml.apache.org/xml-soap which is not supported in JAX-WS." + wde.showLocation());
                }
            }
            if (!result.isUnsupportedSoapEncodingNS()) {
                result.setUnsupportedSoapEncodingNS(ValidateWSDLUtil.hasNamespace(wde, SOAP_ENCODING_NAMESPACE));
                if (result.isUnsupportedSoapEncodingNS()) {
                    result.logError("This WSDL uses namespace http://schemas.xmlsoap.org/soap/encoding/ which is not supported in JAX-WS." + wde.showLocation());
                }
            }
            if (!result.isUnsupportedWebsphereNS()) {
                result.setUnsupportedWebsphereNS(ValidateWSDLUtil.hasNamespace(wde, WEBSPHERE_WEBSERVICES_NAMESPACE));
                if (result.isUnsupportedWebsphereNS()) {
                    result.logError("This WSDL uses namespace http://websphere.ibm.com/webservices/ which is not supported in JAX-WS." + wde.showLocation());
                }
            }
            if (!result.hasIBMtWASNs() && ValidateWSDLUtil.hasNamespace(wde, IBM_TWAS_NAMESPACE)) {
                result.setHasIbmTwasNs(true);
                result.logWarn("This WSDL uses a WebSphere traditional namespace http://www.ibm.com/ns/2003/06/wsdl/mp which is not supported in Liberty." + wde.showLocation());
            }
        }
    }

    private static boolean hasNamespace(WsdlDocumentElement wde, String namespace) {
        return wde.ofElementTypes("schema", "definitions") && wde.hasDeclaredNamespace(namespace) || wde.ofElementType("import") && wde.verifyAttribute("namespace", namespace);
    }

    private static void isSoapOverJmsTransportDefined(WsdlDocumentElement wde, WSDLValidationResult result) {
        if (wde.matchElement(SOAP_NAMESPACE, "binding") && !result.isSoapOverJmsDefined()) {
            result.setJmsDefined(wde.verifyAttribute("transport", "http://schemas.xmlsoap.org/soap/jms"));
            if (result.isSoapOverJmsDefined()) {
                result.logError("SOAP over JMS is not supported in Liberty." + wde.showLocation());
            }
        }
    }

    private static void isRpcEncodedStyle(WsdlDocumentElement wde, WSDLValidationResult result) {
        if (wde.ofNamespace(SOAP_NAMESPACE) && ELEMENTS_TO_CHECK_FOR_RPC_ENCODING.contains(wde.getElementType()) && !result.isRpcEncoded()) {
            result.setRpcEncoded(wde.verifyAttribute("use", "encoded"));
            if (result.isRpcEncoded()) {
                result.logError("Use of SOAP Encoding is not supported. SOAP extension element has use=\"encoded\"" + wde.showLocation());
            }
        }
    }

    private static void collectSoapAddress(WsdlDocumentElement wde, WSDLValidationResult result) {
        WsdlDocumentElement parentElement;
        if (wde.matchElement(SOAP_NAMESPACE, "address") && (parentElement = wde.getParent()).ofElementType("port")) {
            String name2 = parentElement.getAttributeValue("name");
            String location = wde.getAttributeValue("location");
            result.addSoapAddress(name2, location);
        }
    }

    private static void checkElementComplexType(WsdlDocumentElement wde, WSDLValidationResult result) {
        if (wde.matchElement(XML_SCHEMA_NAMESPACE, "complexType")) {
            WsdlDocumentElement parentElement = wde.getParent();
            if (parentElement.ofElementType("element")) {
                if (parentElement.hasComplexType()) {
                    result.logError(MessageFormat.format("The element for \"{0}\" has multiple complexTypes", parentElement.getAttributeValue("name")).concat(parentElement.showLocation()));
                    result.setWsdlInvalid();
                } else {
                    parentElement.setHasComplexType();
                }
            } else if (!parentElement.ofElementType("schema") && !parentElement.ofElementType("redefine")) {
                result.logError("Malformed wsdl. complexType has wrong parent" + wde.showLocation());
                result.setWsdlInvalid();
            }
        }
    }

    private static void collectSchemaElement(WsdlDocumentElement wde, WSDLValidationResult result) {
        if (wde.matchElement(XML_SCHEMA_NAMESPACE, "element") && wde.getParent().ofElementType("schema")) {
            if (!wde.hasAttribute("name")) {
                result.logError("Element requires a name attribute" + wde.showLocation());
                result.setWsdlInvalid();
                return;
            }
            String elementName = wde.getAttributeValue("name");
            if (result.getSchemaElement(elementName) != null) {
                result.logError(MessageFormat.format("Element \"{0}\" is defined multiple times", elementName).concat(wde.showLocation()));
                result.setWsdlInvalid();
            } else {
                result.putSchemaElement(elementName, wde);
            }
        }
    }

    private static void collectInnerElement(XMLEvent event, WsdlDocumentElement prevElem, WSDLValidationResult result) {
        WsdlDocumentElement match;
        WsdlDocumentElement parentElement;
        EndElement ee = event.asEndElement();
        if (ee.getName().getLocalPart().equals("element") && prevElem.ofElementType("element") && prevElem.getAttributeValue("name") != null && (parentElement = prevElem.getParent(match = new WsdlDocumentElement(XML_SCHEMA_NAMESPACE, "element"))) != null) {
            parentElement.addChildElement(prevElem);
            result.putInnerElement(prevElem.getAttributeValue("name"), prevElem);
        }
    }

    private static void collectMessageElement(WsdlDocumentElement wde, WSDLValidationResult result) {
        if (wde.matchElement(WSDL_NAMESPACE, "message")) {
            String messageName = wde.getAttributeValue("name");
            if (messageName == null || messageName.isEmpty()) {
                result.logError("WSDL Message Element has missing or empty name attribute" + wde.showLocation());
                result.setWsdlInvalid();
            } else if (result.getWsdlMessageElement(messageName) == null) {
                result.putWsdlMessageElement(messageName, wde);
            } else {
                result.logError("WSDL Message Element with name attribute \"" + messageName + "\" already exists" + wde.showLocation());
                result.setWsdlInvalid();
            }
        }
    }

    private static void collectWsdlPart(WsdlDocumentElement wde, WSDLValidationResult result) {
        if (wde.matchElement(WSDL_NAMESPACE, "part")) {
            if (wde.checkHierarchy(WSDL_PART_HIERARCHY)) {
                String wsdlMessageName = wde.getParent().getAttributeValue("name");
                WsdlDocumentElement messageElement = result.getWsdlMessageElement(wsdlMessageName);
                String partName = wde.getAttributeValue("name");
                if (partName == null || partName.isEmpty()) {
                    result.logError("Missing name attribute on <wsdl:part>" + wde.showLocation());
                    result.updateValidMimeType(false);
                } else if (messageElement.containsPart(partName)) {
                    result.logError("Multiple definitions for <wsdl:part name=\"" + partName + "\">" + wde.showLocation());
                    result.updateValidMimeType(false);
                } else {
                    messageElement.putPart(partName, wde);
                }
            } else {
                result.logError("Found <wsdl:part> without <wsdl:message> parent" + wde.showLocation());
                result.setWsdlInvalid();
            }
        }
    }

    private static void collectMimePart(WsdlDocumentElement wde, WSDLValidationResult result) {
        HashMap<String, WsdlDocumentElement> mimeParts;
        String wsdlIOName;
        if (wde.matchElement(MIME_NAMESPACE, "multipartRelated")) {
            wsdlIOName = wde.getParent().getAttributeValue("name");
            mimeParts = new HashMap<String, WsdlDocumentElement>();
            result.addMimePartsMap(wsdlIOName, mimeParts);
        }
        if (wde.matchElement(SOAP_NAMESPACE, "body") || wde.matchElement(MIME_NAMESPACE, "content")) {
            if (wde.getParent().matchElement(MIME_NAMESPACE, "part") && !wde.checkHierarchy(MIME_PART_HIERARCHY)) {
                result.updateValidMimeType(false);
            }
            if (wde.checkHierarchy(MIME_PART_FULL_HIERARCHY)) {
                String partName;
                wsdlIOName = wde.getParent(new WsdlDocumentElement(WSDL_NAMESPACE, "input", "output")).getAttributeValue("name");
                mimeParts = result.getMimePartsMap(wsdlIOName);
                String string = partName = wde.matchElement(SOAP_NAMESPACE, "body") ? wde.getAttributeValue("parts") : wde.getAttributeValue("part");
                if (partName == null || partName.isEmpty()) {
                    result.logError("Missing part(s) attribute in <mime:part> content" + wde.showLocation());
                    result.updateValidMimeType(false);
                } else if (mimeParts.keySet().contains(partName)) {
                    result.logError("Multiple definitions for <mime:part> " + partName + wde.showLocation());
                    result.updateValidMimeType(false);
                } else {
                    mimeParts.put(partName, wde);
                }
            }
        }
    }

    private static void validateMime(WSDLValidationResult result) {
        HashSet<String> mimePartsKeys = new HashSet<String>(result.getMimeCollections().keySet());
        for (String ioName : mimePartsKeys) {
            ValidateWSDLUtil.checkWsdlPartsAndElements(ioName, result);
        }
    }

    private static void checkWsdlPartsAndElements(String ioName, WSDLValidationResult result) {
        WsdlDocumentElement wsdlMessage = result.getWsdlMessageElement(ioName);
        if (wsdlMessage != null) {
            HashMap<String, WsdlDocumentElement> wsdlParts = result.getWsdlMessageElement(ioName).getPartsMap();
            HashMap<String, WsdlDocumentElement> mimeParts = result.getMimePartsMap(ioName);
            boolean setsEqual = wsdlParts.keySet().equals(mimeParts.keySet());
            result.updateValidMimeType(setsEqual);
            if (setsEqual) {
                for (String partName : wsdlParts.keySet()) {
                    WsdlDocumentElement wsdlPart = wsdlParts.get(partName);
                    WsdlDocumentElement mimePart = mimeParts.get(partName);
                    ValidateWSDLUtil.validateWsdlElementType(partName, wsdlPart, mimePart, result);
                }
            } else {
                ValidateWSDLUtil.logUnmatchedParts(ioName, wsdlParts, mimeParts, result);
            }
        } else {
            result.logError(String.format("The defined MIME parts for %s does not have a corresponding WSDL message", ioName));
            result.updateValidMimeType(false);
        }
    }

    private static void validateWsdlElementType(String partName, WsdlDocumentElement wsdlPart, WsdlDocumentElement mimePart, WSDLValidationResult result) {
        String elementAttribute = wsdlPart.getAttributeValue("element");
        if (elementAttribute == null) {
            result.logError(MessageFormat.format("WSDL part \"{0}\" does not define an associated element.", partName).concat(wsdlPart.showLocation()));
            result.updateValidMimeType(false);
            return;
        }
        String elementDefinition = elementAttribute.split(":", 2)[1];
        WsdlDocumentElement schemaElement = result.getSchemaElement(elementDefinition);
        if (schemaElement == null) {
            result.logError(MessageFormat.format("Missing element definition \"{0}\" for WSDL part \"{1}\"", elementDefinition, partName).concat(wsdlPart.showLocation()));
        } else if (schemaElement.hasComplexType()) {
            result.logWarn("Complex types are not supported with MIME for interoperability between JAX-WS and JAX-RPC".concat(schemaElement.showLocation()));
            result.setNotInteroperable();
        }
    }

    private static void checkIfValidMimeType(WsdlDocumentElement wde, WSDLValidationResult result) {
        String type = wde.getAttributeValue("type");
        if (type == null) {
            result.logError(MessageFormat.format("Element \"{0}\" does not define a type", wde.getAttributeValue("name")).concat(wde.showLocation()));
            result.updateValidMimeType(false);
            return;
        }
        if ((type.contains("base64Binary") || type.contains("hexBinary")) && (type = wde.getAttributeValue("expectedContentTypes")) == null) {
            result.logError(MessageFormat.format("Element \"{0}\" does not define expectedContentTypes", wde.getAttributeValue("name")).concat(wde.showLocation()));
            result.updateValidMimeType(false);
            return;
        }
        if (!VALID_MIME_TYPES.matcher(type).matches()) {
            result.logError(MessageFormat.format("Invalid MIME type \"{0}\" used for element \"{1}\"", type, wde.getAttributeValue("name")).concat(wde.showLocation()));
            result.updateValidMimeType(false);
        }
    }

    private static void logUnmatchedParts(String ioName, HashMap<String, WsdlDocumentElement> wsdlParts, HashMap<String, WsdlDocumentElement> mimeParts, WSDLValidationResult result) {
        HashSet<String> union = new HashSet<String>(mimeParts.keySet());
        union.addAll(wsdlParts.keySet());
        for (String part : union) {
            if (!wsdlParts.containsKey(part)) {
                result.logWarn(MessageFormat.format("Unmatched <mime:part>: {0}, belonging to <wsdl:message name=\"{1}\">", part, ioName).concat(mimeParts.get(part).showLocation()));
            }
            if (mimeParts.containsKey(part)) continue;
            result.logWarn(MessageFormat.format("Unmatched <wsdl:part>: {0}, belonging to <wsdl:input/output name=\"{1}\">", part, ioName).concat(wsdlParts.get(part).showLocation()));
        }
    }

    private static WstxEventReader getImportLocationPair(String importedWsdlLocation, String wsdlLocation, WSDLValidationResult result) throws XMLStreamException {
        URL wsdlURL;
        WstxInputFactory xmlif = (WstxInputFactory)WstxInputFactory.newInstance();
        MalformedURLException urlException = null;
        Exception relativePathException = null;
        try {
            wsdlURL = new URL(importedWsdlLocation);
            if (wsdlURL != null) {
                WstxEventReader xmler = (WstxEventReader)xmlif.createXMLEventReader(wsdlURL);
                return xmler;
            }
        }
        catch (MalformedURLException e) {
            urlException = e;
        }
        try {
            wsdlURL = new URL(wsdlLocation);
            File wsdlDirectory = new File(wsdlURL.toURI()).getParentFile();
            File fullPathToImportedWsdl = new File(wsdlDirectory, importedWsdlLocation);
            if (fullPathToImportedWsdl != null && fullPathToImportedWsdl.exists()) {
                WstxEventReader xmler = (WstxEventReader)xmlif.createXMLEventReader(fullPathToImportedWsdl);
                return xmler;
            }
        }
        catch (Exception e) {
            relativePathException = e;
        }
        StringBuilder fullErrorMessage = new StringBuilder(String.format("Imported wsdl or xsd %s specified in %s could not be found. ", importedWsdlLocation, wsdlLocation));
        if (relativePathException != null) {
            fullErrorMessage.append(relativePathException);
        }
        if (urlException != null) {
            fullErrorMessage.append(" " + urlException);
        }
        result.logError(fullErrorMessage.toString());
        return null;
    }

    private static void checkForExternalConfig(WsdlDocumentElement wde, WSDLValidationResult result, Stack<WstxEventReader> eventReaders) {
        if (wde.matchElement(WSDL_NAMESPACE, "import")) {
            if (wde.hasAttribute("location")) {
                ValidateWSDLUtil.validateImport("location", wde, result, eventReaders);
            } else {
                result.setImportLocationValid(false);
                result.logError("Missing location attribute. Cannot link schema or wsdl without a specified import location." + wde.showLocation());
            }
        } else if (wde.matchElement(XML_SCHEMA_NAMESPACE, "import") && wde.hasAttribute("schemaLocation")) {
            ValidateWSDLUtil.validateImport("schemaLocation", wde, result, eventReaders);
        }
    }

    private static void validateImport(String attrName, WsdlDocumentElement wde, WSDLValidationResult result, Stack<WstxEventReader> eventReaders) {
        try {
            WstxEventReader xmler = ValidateWSDLUtil.getImportLocationPair(wde.getAttributeValue(attrName), wde.getLocation().getSystemId(), result);
            result.setImportLocationValid(xmler != null);
            if (xmler != null) {
                eventReaders.push(xmler);
            } else {
                result.logError("Invalid import " + attrName + "." + wde.showLocation());
            }
        }
        catch (Exception e) {
            result.setImportLocationValid(false);
            result.logError(e.getMessage());
        }
    }

    private static void verifyValidPort(WSDLValidationResult result) {
        if (!result.containsValidPort()) {
            result.logError("WSDL does not define at least one port that uses SOAP namespace: http://schemas.xmlsoap.org/wsdl/soap/");
        }
    }

    static {
        ELEMENTS_TO_CHECK_FOR_RPC_ENCODING = Arrays.asList("body", "header", "headerFault", "fault");
        VALID_MIME_TYPES = Pattern.compile("image/(gif|jpeg)|text/(plain|xml)|application/xml|multipart/.+");
        WSDL_PART_HIERARCHY = Arrays.asList(new WsdlDocumentElement(WSDL_NAMESPACE, "message"));
        MIME_PART_HIERARCHY = Arrays.asList(new WsdlDocumentElement(MIME_NAMESPACE, "part"), new WsdlDocumentElement(MIME_NAMESPACE, "multipartRelated"));
        MIME_PART_FULL_HIERARCHY = Arrays.asList(new WsdlDocumentElement(MIME_NAMESPACE, "part"), new WsdlDocumentElement(MIME_NAMESPACE, "multipartRelated"), new WsdlDocumentElement(WSDL_NAMESPACE, "input", "output"), new WsdlDocumentElement(WSDL_NAMESPACE, "operation"), new WsdlDocumentElement(WSDL_NAMESPACE, "binding"));
        XSD_GCAL_TYPES = new HashSet<String>(Arrays.asList("gYear", "gYearMonth", "gMonth", "gMonthDay", "gDay"));
    }
}

