/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.appserver.tools.jaxrpc.common.data;

import com.ibm.websphere.appserver.tools.jaxrpc.common.data.ServiceEndpointInterface;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.WSDLResource;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class ClientServiceEndpointInterface
extends ServiceEndpointInterface {
    String renamed_seiName;
    String seiNameJaxws;
    String serviceLocatorClass;
    String serviceLocatorPath;
    String serviceClass = null;
    String servicePath;
    boolean genericService = false;
    Set<String> seiRefs = new HashSet<String>();
    Set<String> seiServiceRefs = new HashSet<String>();
    Set<String> serviceLocatorRefs = new HashSet<String>();
    String alternateServiceName;
    String alternateSeiName;

    public ClientServiceEndpointInterface(String seiName, String serviceClass, WSDLResource wsdlResource) {
        super(seiName, wsdlResource);
        this.renamed_seiName = seiName + "_original";
        this.setServiceName(serviceClass);
    }

    public ClientServiceEndpointInterface(String seiName) {
        super(seiName);
        this.renamed_seiName = seiName + "_original";
    }

    @Override
    public String toString() {
        return "ClientServiceEndpointInterface[seiName: " + this.seiName + ", renamed: " + this.renamed_seiName + "]";
    }

    public String getRenamedSei() {
        return this.renamed_seiName;
    }

    public String getSeiNameJaxws() {
        return this.seiNameJaxws;
    }

    public String getServiceName() {
        return this.serviceClass;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public void setSeiNameJaxws(String name2) {
        this.seiNameJaxws = name2;
    }

    public boolean isGenericService() {
        return this.genericService;
    }

    public void setServiceName(String serviceClass) {
        if (this.serviceClass == null) {
            this.genericService = serviceClass.equals("javax.xml.rpc.Service");
        }
        this.serviceClass = serviceClass;
    }

    public void setAlternateServiceName(String altClass) {
        this.alternateServiceName = altClass;
    }

    public String getAlternateServiceName() {
        return this.alternateServiceName;
    }

    public void setAlternateSeiName(String altClass) {
        this.alternateSeiName = altClass;
    }

    public String getAlternateSeiName() {
        return this.alternateSeiName;
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public void addServiceLocator(String serviceLocatorClass, String serviceLocatorPath) {
        this.serviceLocatorClass = serviceLocatorClass;
        this.serviceLocatorPath = serviceLocatorPath;
    }

    public String getServiceLocatorName() {
        return this.serviceLocatorClass;
    }

    public String getServiceLocatorPath() {
        return this.serviceLocatorPath;
    }

    public void addSEIReference(String refClass, String refPath) {
        if (!(refClass.equals(this.seiName) || refClass.equals(this.serviceClass) || refClass.equals(this.serviceLocatorClass))) {
            this.seiRefs.add(refPath);
        }
    }

    public Set<String> getSEIReferences() {
        return this.seiRefs;
    }

    public void addSEIServiceReference(String refClass, String refPath) {
        if (!refClass.equals(this.serviceClass)) {
            this.seiServiceRefs.add(refPath);
        }
    }

    public Set<String> getSEIServiceReferences() {
        return this.seiServiceRefs;
    }

    public void addServiceLocatorReference(String refPath) {
        if (!refPath.equals(this.serviceLocatorPath)) {
            this.serviceLocatorRefs.add(refPath);
        }
    }

    public Set<String> getSEIServiceLocatorReferences() {
        return this.serviceLocatorRefs;
    }

    public String getWsImportDirPath() {
        return this.getWsdlResource().getWsImportDirPath();
    }

    public String getGeneratedClassFilePath(String className) {
        String wsimportDirForSEI = this.getWsdlResource().getWsImportDirPath();
        String packageClass = className.replace(".", File.separator) + ".class";
        return wsimportDirForSEI + File.separator + packageClass;
    }

    public File getGeneratedClassFile(String className) {
        File genClassFile = new File(this.getGeneratedClassFilePath(className));
        if (genClassFile.exists()) {
            return genClassFile;
        }
        return null;
    }
}

