/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.appconversion.jsp.core.model;

import com.ibm.ws.appconversion.jsp.core.util.CoreJspHelper;
import java.util.Map;

public class TagIndex {
    private String data;
    private String tagName;
    private String prefix;
    private String elementName;
    private int index;
    private int line;
    private boolean isValidTag = false;
    private Map<String, Integer> _attCache = null;

    public TagIndex(String data, int index, int curLine) {
        this.data = data;
        this.index = index;
        this.line = curLine;
        String tag = this.getTagName();
        String[] tagParts = tag.split(":");
        if (tagParts.length == 2) {
            this.isValidTag = true;
            this.prefix = tagParts[0];
            this.elementName = tagParts[1];
        }
    }

    public boolean isValidTag() {
        return this.isValidTag;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getElement() {
        return this.elementName;
    }

    public int getLine() {
        return this.line;
    }

    public String getTagData() {
        return this.data;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return String.valueOf(this.getTagName()) + " [" + this.data + ":" + this.index + "]" + this.getAttributes();
    }

    public String getTagName() {
        if (this.tagName == null) {
            char[] chars = this.data.toCharArray();
            int i = 0;
            StringBuilder name2 = new StringBuilder();
            while (i < this.data.length() && !Character.isLetterOrDigit(chars[i])) {
                ++i;
            }
            while (i < this.data.length() && (Character.isLetterOrDigit(chars[i]) || chars[i] == ':' || chars[i] == '-')) {
                name2.append(chars[i]);
                ++i;
            }
            this.tagName = name2.toString();
        }
        return this.tagName;
    }

    public Map<String, Integer> getAttributes() {
        if (this._attCache == null) {
            this._attCache = CoreJspHelper.getAttributes(this.data);
        }
        return this._attCache;
    }
}

