/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature;

import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import java.util.Locale;

public enum AppForceRestart {
    INSTALL,
    UNINSTALL,
    ALWAYS,
    NEVER;


    @FFDCIgnore(value={IllegalArgumentException.class})
    public static AppForceRestart fromString(String s) {
        if (s == null || s.isEmpty()) {
            return NEVER;
        }
        AppForceRestart result = NEVER;
        try {
            String[] values;
            for (String part : values = s.split(",")) {
                AppForceRestart r1 = AppForceRestart.valueOf(part.trim().toUpperCase(Locale.ENGLISH));
                result = result == NEVER ? r1 : ALWAYS;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    public boolean matches(AppForceRestart expectedValue) {
        switch (expectedValue) {
            case INSTALL: {
                return this == INSTALL || this == ALWAYS;
            }
            case UNINSTALL: {
                return this == UNINSTALL || this == ALWAYS;
            }
            case ALWAYS: {
                return this == ALWAYS;
            }
            case NEVER: {
                return this == NEVER;
            }
        }
        return false;
    }
}

