/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.asm;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageDetails;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.logging.Level;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

public class AnnotationLink
extends AnnotationVisitor {
    private final ClassDataStore store;
    private String reportMethodName = null;
    private String methodSignature = null;
    private int currentLine = 0;
    private AnnotationDetails ad = null;
    private String lastAttributeName = null;
    private static boolean DEBUG = false;

    public AnnotationLink(ClassDataStore store, AnnotationDetails ad) {
        super(589824);
        this.store = store;
        this.ad = ad;
    }

    public AnnotationLink(ClassDataStore store, AnnotationDetails ad, String methodName, String methodSignature, int currentLine) {
        super(589824);
        this.store = store;
        this.reportMethodName = Messages.getFormattedMessage(Messages.getString("Report_Reference_Method"), methodName);
        this.methodSignature = methodSignature;
        this.currentLine = currentLine;
        this.ad = ad;
    }

    @Override
    public void visit(String name2, Object value) {
        if (name2 == null) {
            name2 = this.lastAttributeName;
        }
        ReportUtility.logger.get().log(Level.FINEST, "visit annotation Name: " + name2);
        if (value != null) {
            ReportUtility.logger.get().log(Level.FINEST, "visit annotation Value: " + value.toString());
        }
        if (value instanceof String) {
            if (this.reportMethodName != null) {
                this.store.addStringLiteral((String)value, this.reportMethodName, this.currentLine);
            } else {
                this.store.addStringLiteral((String)value, Messages.getString("Report_Reference_Class_Annotation"), 0);
            }
        }
        if (this.ad != null) {
            if (this.reportMethodName != null) {
                if (value instanceof Type) {
                    this.store.addPackageDesc((Type)value, this.reportMethodName, this.currentLine, 2);
                }
                String methodDesc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), this.reportMethodName, ClassOrPackageDetails.getTypeDescription(2));
                this.store.addAnnotationDetails(this.ad, name2, value, methodDesc, this.currentLine);
            } else {
                if (value instanceof Type) {
                    this.store.addPackageDesc((Type)value, Messages.getString("Report_Reference_Class_Annotation"), 0);
                }
                this.store.addAnnotationDetails(this.ad, name2, value, null, 0);
            }
        }
        super.visit(name2, value);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name2, String desc) {
        if (name2 == null) {
            name2 = this.lastAttributeName;
        }
        ReportUtility.logger.get().log(Level.FINEST, "visitAnnotation name: " + name2);
        ReportUtility.logger.get().log(Level.FINEST, "visitAnnotation desc: " + desc);
        int refType = 0;
        if (this.ad != null) {
            refType = this.ad.getReferenceType();
        }
        AnnotationDetails ad2 = null;
        if (this.reportMethodName != null) {
            this.store.addPackageDesc(Type.getType(desc), this.reportMethodName, this.currentLine, 2);
            ad2 = this.store.addAnnotation(desc, this.reportMethodName, this.currentLine, refType);
            if (ad2 != null) {
                ad2.setMethodSignature(this.methodSignature);
            }
        } else {
            this.store.addPackageDesc(Type.getType(desc), Messages.getString("Report_Reference_Class_Annotation"), 0);
            ad2 = this.store.addAnnotation(desc, Messages.getString("Report_Reference_Annotation"), 0, refType);
        }
        return new AnnotationLink(this.store, ad2);
    }

    @Override
    public AnnotationVisitor visitArray(String name2) {
        ReportUtility.logger.get().log(Level.FINEST, "visitArray annotation name: " + name2);
        this.lastAttributeName = name2;
        return this;
    }

    @Override
    public void visitEnum(String name2, String desc, String value) {
        if (name2 == null) {
            name2 = this.lastAttributeName;
        }
        ReportUtility.logger.get().log(Level.FINEST, "visitEnum annotation name: " + name2);
        ReportUtility.logger.get().log(Level.FINEST, "visitEnum annotation desc: " + desc);
        if (value != null) {
            ReportUtility.logger.get().log(Level.FINEST, "visitEnum annotation Value: " + value);
        }
        Type type = Type.getType(desc);
        if (this.reportMethodName != null) {
            this.store.addPackageDesc(type, this.reportMethodName, this.currentLine, 2);
            this.store.addField(type, value, this.reportMethodName, this.currentLine);
            if (this.ad != null) {
                String methodDesc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), this.reportMethodName, ClassOrPackageDetails.getTypeDescription(2));
                this.store.addAnnotationDetails(this.ad, desc, name2, value, methodDesc, this.currentLine);
            }
        } else {
            this.store.addPackageDesc(type, Messages.getString("Report_Reference_Class_Annotation"), 0);
            this.store.addField(type, value, Messages.getString("Report_Reference_Class_Annotation"), 0);
            if (this.ad != null) {
                this.store.addAnnotationDetails(this.ad, desc, name2, value, null, 0);
            }
        }
    }
}

