/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.asm;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.AnnotationLink;
import com.ibm.ws.report.binary.asm.FieldLink;
import com.ibm.ws.report.binary.asm.MethodLink;
import com.ibm.ws.report.binary.asm.SignatureLink;
import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;

public class ClassLink
extends ClassVisitor {
    private final ClassDataStore store;
    private int methodNumber = 0;
    private static boolean DEBUG = false;

    public ClassLink(ClassDataStore store) {
        super(589824);
        this.store = store;
    }

    @Override
    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces) {
        ReportUtility.logger.get().log(Level.FINEST, "Name: " + name2);
        ReportUtility.logger.get().log(Level.FINEST, "Super: " + superName);
        this.store.setClassData(name2, superName, interfaces, access);
        this.store.addPackageName(name2, Messages.getString("Report_Reference_Class_Declaration"), 0);
        if (signature == null) {
            String[] stringArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                String inter = stringArray[n2];
                this.store.addPackageName(inter, Messages.getString("Report_Reference_Class_Implements"), 0);
                ++n2;
            }
        } else {
            new SignatureReader(signature).accept(new SignatureLink(this.store, Messages.getString("Report_Reference_Class_Signature"), 0));
        }
        super.visit(version, access, name2, signature, superName, interfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        ReportUtility.logger.get().log(Level.FINEST, "Visiting annotation: " + desc);
        Type descType = Type.getType(desc);
        this.store.addClassAnnotation(descType);
        this.store.setHasAnnotations(true);
        boolean isInterface = this.store.isInterface();
        String ref = isInterface ? Messages.getString("Report_Reference_Interface_Annotation") : Messages.getString("Report_Reference_Class_Annotation");
        int annoType = isInterface ? 4 : 0;
        this.store.addPackageDesc(descType, ref, 0);
        AnnotationDetails ad = this.store.addAnnotation(desc, ref, 0, annoType);
        return new AnnotationLink(this.store, ad);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        ReportUtility.logger.get().log(Level.FINEST, "Visiting type annotation: " + desc);
        this.store.setHasAnnotations(true);
        this.store.addPackageDesc(Type.getType(desc), Messages.getString("Report_Reference_Type_Annotation"), 0);
        AnnotationDetails ad = this.store.addAnnotation(desc, Messages.getString("Report_Reference_Type_Annotation"), 0, 3);
        return new AnnotationLink(this.store, ad);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
        String typeString;
        Type type;
        int n;
        int n2;
        Type[] typeArray;
        ReportUtility.logger.get().log(Level.FINEST, "Visiting method: " + name2 + " desc: " + desc + " access: " + access);
        String methodSignature = this.buildMethodSignature(desc, name2);
        List<String> exceptionList = exceptions == null ? null : Arrays.asList(exceptions);
        boolean isPublic = (access & 1) == 1;
        this.store.addMethodImplemented(name2, methodSignature, desc, exceptionList, isPublic);
        String reportMethodName = Messages.getFormattedMessage(Messages.getString("Report_Reference_Method"), name2);
        ArrayList<String> arguments = new ArrayList<String>();
        if (signature == null) {
            this.store.addPackageDesc(Type.getReturnType(desc), reportMethodName, 0, 1);
            typeArray = Type.getArgumentTypes(desc);
            n2 = typeArray.length;
            n = 0;
            while (n < n2) {
                type = typeArray[n];
                this.store.addPackageDesc(type, reportMethodName, 0, 3);
                typeString = this.store.getTypeString(type);
                arguments.add(typeString);
                ++n;
            }
        } else {
            typeArray = Type.getArgumentTypes(desc);
            n2 = typeArray.length;
            n = 0;
            while (n < n2) {
                type = typeArray[n];
                typeString = this.store.getTypeString(type);
                arguments.add(typeString);
                ++n;
            }
            new SignatureReader(signature).accept(new SignatureLink(this.store, Messages.getFormattedMessage(Messages.getString("Report_Reference_Method_Signature"), name2), 0));
        }
        ArrayList<String> throwsExceptions = new ArrayList<String>();
        if (exceptions != null) {
            String[] stringArray = exceptions;
            int n3 = exceptions.length;
            n2 = 0;
            while (n2 < n3) {
                String exc = stringArray[n2];
                String className = exc.replace('/', '.');
                throwsExceptions.add(className);
                this.store.addPackageName(className, reportMethodName, 0, 5);
                ReportUtility.logger.get().log(Level.FINEST, "Visiting method: " + name2 + " throws exception: " + className);
                ++n2;
            }
        }
        boolean isStatic = (access & 8) == 8;
        return new MethodLink(this.store, name2, methodSignature, arguments, throwsExceptions, isStatic, this.methodNumber++);
    }

    private String buildMethodSignature(String desc, String methodName) {
        StringBuilder sb = new StringBuilder();
        Type type = Type.getType(desc);
        String returnTypeStr = "";
        String[] argumentTypeStr = new String[]{};
        if (type != null) {
            returnTypeStr = this.store.getTypeString(type.getReturnType());
            argumentTypeStr = this.store.getArgumentTypes(type.getArgumentTypes());
        }
        sb.append(returnTypeStr);
        sb.append(" ");
        sb.append(methodName);
        sb.append("(");
        int i = 0;
        while (i < argumentTypeStr.length) {
            sb.append(argumentTypeStr[0]);
            if (i + 1 < argumentTypeStr.length) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public FieldVisitor visitField(int access, String name2, String desc, String signature, Object value) {
        ReportUtility.logger.get().log(Level.FINEST, "Visiting field: " + name2 + " desc: " + desc);
        if (value != null) {
            ReportUtility.logger.get().log(Level.FINEST, "Visiting field value: " + value);
        }
        if (signature == null) {
            this.store.addPackageDesc(Type.getType(desc), Messages.getFormattedMessage(Messages.getString("Report_Reference_Field"), name2), 0);
        } else {
            new SignatureReader(signature).acceptType(new SignatureLink(this.store, Messages.getFormattedMessage(Messages.getString("Report_Reference_Field_Signature"), name2), 0));
        }
        if (value instanceof Type) {
            this.store.addPackageDesc((Type)value, Messages.getFormattedMessage(Messages.getString("Report_Reference_Field"), name2), 0);
        } else if (value instanceof String) {
            this.store.addStringLiteral((String)value, Messages.getFormattedMessage(Messages.getString("Report_Reference_Field"), name2), 0);
        }
        this.store.addClassField(name2, access);
        return new FieldLink(this.store, this.store.getTypeClassName(desc), name2);
    }
}

