/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.cmdline;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.analyze.AnalysisResults;
import com.ibm.ws.report.analyze.IdentifierObject;
import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.cmdline.DriveScan;
import com.ibm.ws.report.binary.cmdline.DriveScanGenerateConfig;
import com.ibm.ws.report.binary.cmdline.DriveScanInventory;
import com.ibm.ws.report.binary.cmdline.utilities.ReportBuilderHelper;
import com.ibm.ws.report.binary.configutility.generator.LibertyServerXml;
import com.ibm.ws.report.binary.configutility.generator.TargetConfig;
import com.ibm.ws.report.binary.configutility.generator.WSAdminScript;
import com.ibm.ws.report.binary.configutility.mutableconfig.SensitiveDataHelper;
import com.ibm.ws.report.binary.configutility.twas.ConfigManager;
import com.ibm.ws.report.binary.reader.BinaryReportReader;
import com.ibm.ws.report.binary.rules.Rule;
import com.ibm.ws.report.binary.utilities.BinaryReportBuilder;
import com.ibm.ws.report.binary.utilities.ConfigFeatureVersionInfo;
import com.ibm.ws.report.inventory.ArchiveInventory;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.technology.TechSummary;
import com.ibm.ws.report.utilities.FileComparator;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.writer.ReportWriter;
import com.ibm.ws.report.writer.html.HTMLDetailAnalysisStreamlinedReportWriter;
import com.ibm.ws.report.writer.html.HTMLEvaluationReportWriter;
import com.ibm.ws.report.writer.html.HTMLInventoryReportWriter;
import com.ibm.ws.report.writer.html.HTMLMigrationReportWriter;
import com.ibm.ws.report.writer.json.JSONDetailAnalysisReportWriter;
import com.ibm.ws.report.writer.json.JSONEvaluationReportWriter;
import com.ibm.ws.report.writer.json.JSONInventoryReportWriter;
import com.ibm.ws.report.writer.json.JSONMigrationReportWriter;
import com.ibm.ws.report.writer.xml.ServerXmlWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.xml.transform.TransformerException;

public class DriveScanAll
extends DriveScan {
    BinaryReportBuilder _analyze = null;
    BinaryReportBuilder _inventory = null;
    BinaryReportBuilder _generateConfig = null;
    DriveScanGenerateConfig driveScanGenerateConfig;
    Map<ReportInputData.ReportType, Collection<Rule>> _otherRules = new HashMap<ReportInputData.ReportType, Collection<Rule>>();
    private boolean _isDirectoryWithMultipleApps = false;

    public DriveScanAll(ReportInputData data) {
        super(data);
        this.driveScanGenerateConfig = new DriveScanGenerateConfig(data);
    }

    @Override
    public String getDefaultReportName() {
        return "MigrationReport";
    }

    @Override
    public Map<String, String> getRuleHelp() {
        HashMap<String, String> helpFileNames = null;
        helpFileNames = this._analyze != null ? this._analyze._helpIds : new HashMap<String, String>();
        return helpFileNames;
    }

    @Override
    public Map<String, Rule> getRules() {
        if (this._rules == null) {
            super.getRules();
            this._analyze = ReportBuilderHelper.loadAnalyzeRules(_data);
            this.setReturnCode(this._analyze.getReturnCode());
            if (this._analyze._foundInvalidRule) {
                ReportUtility.logger.get().log(Level.SEVERE, com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScan_No_Rules_Found"));
                if (!_hiddenJunitFlag) {
                    System.exit(2);
                }
                return null;
            }
            if (!this._analyze._foundInvalidRule && this._analyze._reportRules != null && !this._analyze._reportRules.isEmpty()) {
                this._otherRules.put(ReportInputData.ReportType.ANALYZE, this._analyze._reportRules.values());
            }
            this._inventory = ReportBuilderHelper.loadInventoryRules();
            if (this._inventory._reportRules != null && !this._inventory._reportRules.isEmpty()) {
                this._otherRules.put(ReportInputData.ReportType.INVENTORY, this._inventory._reportRules.values());
            }
            this._generateConfig = ReportBuilderHelper.loadConfigRules(true);
            if (this._generateConfig._reportRules != null && !this._generateConfig._reportRules.isEmpty()) {
                Rule detectJndiRule = this._generateConfig._reportRules.get("DetectConfigJNDI");
                this.configRules.add(detectJndiRule);
                this._generateConfig._reportRules.remove("DetectConfigJNDI");
                this._otherRules.put(ReportInputData.ReportType.GENERATE_CONFIG, this._generateConfig._reportRules.values());
            }
        }
        return this._rules;
    }

    @Override
    public BinaryReportReader getBinaryReportReader() {
        return this.getBinaryReportReader(null, null);
    }

    public BinaryReportReader getBinaryReportReader(Map<String, Map<String, IdentifierObject>> possibleIdentifierNames, Set<String> appsUsingSessions) {
        Map<String, Rule> myrules = this.getRules();
        if (myrules != null && !myrules.isEmpty()) {
            this._reader = new BinaryReportReader(_data, myrules, this.getTechnologyFactory().getListOfTechnologies(), this.getNonTechRules(), this._otherRules, this.configRules, possibleIdentifierNames, appsUsingSessions);
        }
        return this._reader;
    }

    @Override
    public void runReport() {
        List<File> apps = _data.getProjectFiles();
        Collections.sort(apps, new FileComparator());
        List<String> appNames = null;
        if (apps.size() > 1) {
            this._isDirectoryWithMultipleApps = true;
        }
        appNames = _data.getProjectNames();
        Map<File, String> mapOfAppsToProfiles = _data.getMapOfAppsToProfiles();
        Collections.sort(appNames);
        File outputDir = _data.getOutputDir();
        String outputDirPath = outputDir == null ? "" : DriveScanAll.getOutputDirPath(outputDir);
        String defaultReportName = "_" + this.getDefaultReportName();
        Boolean multpleHTMLOutputs = false;
        StringBuilder sensitiveDataFilesSB = new StringBuilder();
        int i = 0;
        for (File app : apps) {
            Map<ReportInputData.OutputType, File> outputFileMap = _data.getOutputFile();
            File outputFile = null;
            try {
                String appName = app.getName();
                System.out.println(com.ibm.ws.report.binary.cmdline.Messages.getFormattedMessage(com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScanGenerateConfig_Processing"), appName));
                Map<ReportInputData.OutputType, Set<String>> outputMap = this.generateReportString(app, appNames.get(i++), sensitiveDataFilesSB);
                String nameForFile = null;
                String dirPath = _data.getProjectDirPathNormalized(app.getAbsolutePath());
                if (this._isDirectoryWithMultipleApps) {
                    String subDir = ReportUtility.getSubDir(DriveScanAll.getFileName(app), dirPath, appName);
                    nameForFile = subDir == null ? outputDirPath + appName + defaultReportName : outputDirPath + subDir.replaceAll("/", "_") + "_" + appName + defaultReportName;
                } else if (outputFileMap.isEmpty()) {
                    nameForFile = outputDirPath + appName + defaultReportName;
                }
                for (ReportInputData.OutputType outputType : _data.getOutputType()) {
                    Set<String> outputs = outputMap.get((Object)outputType);
                    if (ReportInputData.OutputType.HTML == outputType && outputs.size() > 1) {
                        multpleHTMLOutputs = true;
                    }
                    for (String output : outputs) {
                        ReportInputData.OutputType outputTypeToUse = outputType;
                        if (outputs.size() == 1) {
                            outputFile = outputFileMap.get((Object)outputType);
                            if (mapOfAppsToProfiles != null && !mapOfAppsToProfiles.isEmpty()) {
                                nameForFile = mapOfAppsToProfiles.get(app) + File.separator + nameForFile;
                            }
                            if (nameForFile != null) {
                                outputFile = new File(nameForFile + outputType.getExtension());
                            }
                        } else {
                            nameForFile = appName + "_";
                            if (mapOfAppsToProfiles != null && !mapOfAppsToProfiles.isEmpty()) {
                                nameForFile = mapOfAppsToProfiles.get(app) + File.separator + nameForFile;
                            }
                            if (ReportInputData.OutputType.HTML == outputType && output.contains(Messages.getString("INVENTORY_REPORT_MAIN_TITLE")) || ReportInputData.OutputType.JSON == outputType && output.contains("\"report\": \"inventory\"")) {
                                nameForFile = nameForFile + "InventoryReport";
                                outputFile = new File(outputDirPath + nameForFile + outputType.getExtension());
                            } else if (ReportInputData.OutputType.HTML == outputType && output.contains(Messages.getString("TECH_EVAL_REPORT_TITLE")) || ReportInputData.OutputType.JSON == outputType && output.contains("\"report\": \"technology\"")) {
                                nameForFile = nameForFile + "TechnologyReport";
                                outputFile = new File(outputDirPath + nameForFile + outputType.getExtension());
                            } else if (ReportInputData.OutputType.HTML == outputType && output.contains(Messages.getString("ANALYSIS_REPORT_HEADER")) || ReportInputData.OutputType.JSON == outputType && output.contains("\"report\": \"analysis\"")) {
                                nameForFile = nameForFile + "AnalysisReport";
                                outputFile = new File(outputDirPath + nameForFile + outputType.getExtension());
                            } else {
                                outputTypeToUse = ReportInputData.OutputType.XML;
                                nameForFile = nameForFile + "server";
                                outputFile = new File(outputDirPath + nameForFile + outputTypeToUse.getExtension());
                            }
                        }
                        switch (outputTypeToUse) {
                            case HTML: {
                                this.openHtmlReport(outputFile, output, outputType, this._isDirectoryWithMultipleApps || multpleHTMLOutputs != false);
                                break;
                            }
                            case JSON: 
                            case XML: {
                                try {
                                    this.setReturnCode(ReportUtility.writeOutStream(outputFile, output));
                                }
                                catch (Exception e) {
                                    if (outputFile != null) {
                                        if (ReportUtility.isDebug()) {
                                            ReportUtility.logger.get().log(Level.SEVERE, com.ibm.ws.report.binary.cmdline.Messages.getFormattedMessage(com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScan_Error_Write_Report_Log"), outputFile.getAbsolutePath()), e);
                                        } else {
                                            ReportUtility.logger.get().log(Level.SEVERE, com.ibm.ws.report.binary.cmdline.Messages.getFormattedMessage(com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScan_Error_Write_Report"), outputFile.getAbsolutePath(), e.getMessage()));
                                        }
                                    } else if (ReportUtility.isDebug()) {
                                        ReportUtility.logger.get().log(Level.SEVERE, com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScan_Error_Write_Report_No_File_Log"), e);
                                    } else {
                                        ReportUtility.logger.get().log(Level.SEVERE, com.ibm.ws.report.binary.cmdline.Messages.getFormattedMessage(com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScan_Error_Write_Report_No_File"), e.getMessage()));
                                    }
                                    this.setReturnCode(2);
                                }
                                break;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (outputFile != null) {
                    ReportUtility.logger.get().log(Level.SEVERE, com.ibm.ws.report.binary.cmdline.Messages.getFormattedMessage(com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScan_Error_Write_Report_Log"), outputFile.getAbsolutePath()), e);
                } else {
                    ReportUtility.logger.get().log(Level.SEVERE, com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScan_Error_Write_Report_No_File_Log"), e);
                }
                this.setReturnCode(2);
            }
        }
        if (sensitiveDataFilesSB.length() > 0) {
            ReportUtility.logger.get().log(Level.INFO, com.ibm.ws.report.binary.cmdline.Messages.getFormattedMessage(com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScanGenerateConfig_Sensitive_Data_Msg"), sensitiveDataFilesSB.toString()));
        }
        if (!ReportUtility.getFilesWithParsingError().isEmpty()) {
            ReportUtility.logger.get().log(Level.WARNING, com.ibm.ws.report.binary.cmdline.Messages.getFormattedMessage(com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScan_Error_Processing_Files"), ReportUtility.getFilesWithParsingError()));
        }
    }

    @Override
    public String getDefaultReportFileName(File app) {
        return "_MigrationReport";
    }

    @Override
    public Map<ReportInputData.OutputType, String> generateReport() {
        return null;
    }

    public Map<ReportInputData.OutputType, Set<String>> generateReportString(File appFile, String appPath, StringBuilder sensitiveDataFilesSB) throws Exception {
        BinaryReportReader brr;
        EnumMap<ReportInputData.OutputType, Set<String>> resultMap = new EnumMap<ReportInputData.OutputType, Set<String>>(ReportInputData.OutputType.class);
        ArrayList<String> projectName = new ArrayList<String>();
        ArrayList<File> projectFile = new ArrayList<File>();
        projectName.add(appPath);
        if (appFile != null) {
            projectFile.add(appFile);
        }
        _data.setProjectData(projectFile, projectName);
        Map<File, String> mapOfAppsToProfiles = _data.getMapOfAppsToProfiles();
        ReportInputData.AppServer target = _data.getTargetAppServer();
        boolean isLiberty = target == null || target.isLiberty();
        boolean limitFeatures = target != null && (target == ReportInputData.AppServer.OPEN_LIBERTY || target == ReportInputData.AppServer.EASE);
        ConfigManager configMgr = this.getConfigManager(appFile);
        TargetConfig appConfig = null;
        HashSet<String> appsUsingSessions = new HashSet<String>();
        HashMap<String, TargetConfig> mapOfAppToTargetConfig = new HashMap<String, TargetConfig>();
        HashMap<String, Map<String, IdentifierObject>> possibleIdentifierNames = new HashMap<String, Map<String, IdentifierObject>>();
        String appName = appFile.getName();
        if (configMgr != null) {
            possibleIdentifierNames.put(appName, configMgr.getPossibleIdentifierNames());
            String profileName = null;
            if (mapOfAppsToProfiles != null && !mapOfAppsToProfiles.isEmpty()) {
                profileName = mapOfAppsToProfiles.get(appFile);
            }
            File outputFile = this.driveScanGenerateConfig.getOutputFile(_data, DriveScanAll.getFileName(appFile), appName, this._isDirectoryWithMultipleApps, profileName);
            appConfig = isLiberty ? new LibertyServerXml(configMgr, appFile.getName(), outputFile, false) : new WSAdminScript(configMgr, appFile.getName(), outputFile);
            mapOfAppToTargetConfig.put(appName, appConfig);
            this.detectSharedLibraries(appConfig, configMgr.getProfileDir());
        }
        if ((brr = this.getBinaryReportReader(possibleIdentifierNames, appsUsingSessions)) != null) {
            String migratedConfig;
            boolean serverXmlWritten;
            String serverXml;
            boolean isLibertyCoreTarget;
            boolean hasConflicts;
            ReportInputData.TargetCloud cloud;
            ArrayList<String> conflictMessages;
            TreeSet<String> baseFeatures;
            TreeSet<String> coreFeatures;
            ArchiveInventory ai;
            ArrayList<String> sharedLibProjectNames;
            Map<String, String> helpFileNames;
            Map costs;
            Map ruleSeverities;
            Map<String, Map<String, Map<String, List<String>>>> rulesAnalyzedByCategory;
            Map<String, List<DetailResult>> projectsToDetailsFoundAnalyze;
            SortedMap<String, TechSummary> listOfTechSummaries;
            block54: {
                brr.openFile();
                listOfTechSummaries = brr.buildTechResults();
                projectsToDetailsFoundAnalyze = brr.getProjectsToDetailResults(ReportInputData.ReportType.ANALYZE);
                rulesAnalyzedByCategory = this._analyze.getSortedRulesByCategories();
                ruleSeverities = this._analyze._severities;
                costs = this._analyze._costs;
                helpFileNames = this.getRuleHelp();
                Map<String, List<DetailResult>> projectsToDetailsFoundInventory = brr.getProjectsToDetailResults(ReportInputData.ReportType.INVENTORY);
                sharedLibProjectNames = new ArrayList<String>();
                if (_data.hasSharedLibraries()) {
                    for (File nextFile : _data.getSharedLibraryFiles()) {
                        sharedLibProjectNames.add(nextFile.getPath().replace("\\", "/"));
                    }
                    Collections.sort(sharedLibProjectNames);
                }
                ai = DriveScanInventory.createArchiveInventory(projectsToDetailsFoundInventory, sharedLibProjectNames, mapOfAppToTargetConfig, appsUsingSessions, brr.getChecksumMap());
                coreFeatures = new TreeSet<String>();
                baseFeatures = new TreeSet<String>();
                TreeSet<String> configFeatures = new TreeSet<String>();
                conflictMessages = new ArrayList<String>();
                cloud = _data.getTargetCloud();
                hasConflicts = false;
                boolean generateFeatureList = isLiberty || _data.filterAnalysisRulesByFeatureList();
                boolean bl = isLibertyCoreTarget = target != null && target == ReportInputData.AppServer.LIBERTY_CORE;
                if (appConfig != null) {
                    appConfig.setUsedIdentifierNames(brr.getFoundIdentifierNames(appName));
                    if (appConfig instanceof LibertyServerXml) {
                        configFeatures.addAll(((LibertyServerXml)appConfig).getConfigFeatures());
                    }
                }
                if (generateFeatureList) {
                    try {
                        hasConflicts = this.driveScanGenerateConfig.findCorrectFeatureList(coreFeatures, baseFeatures, configFeatures, brr, appPath);
                    }
                    catch (Exception ex) {
                        ReportUtility.logger.get().log(Level.FINE, "Caught exception generating feature list: " + ex);
                        hasConflicts = true;
                    }
                    if (isLiberty) {
                        conflictMessages.addAll(this.driveScanGenerateConfig.conflictMessages);
                    }
                    if (_data.filterAnalysisRulesByFeatureList()) {
                        HashSet<String> allFeatures = new HashSet<String>();
                        if (!hasConflicts) {
                            allFeatures.addAll(this.driveScanGenerateConfig.getRuleSelectedFeatures());
                        }
                        Map<ReportInputData.JavaEEVersion, Set<String>> libertyJavaEEJakartaFeatures = this.driveScanGenerateConfig.getLibertyJavaEEJakartaFeatures();
                        ConfigFeatureVersionInfo cfvi = this.getConfigFeatureVersionInfo(_data.getSourceAppServer(), mapOfAppToTargetConfig);
                        cfvi.setTargetJavaEE(_data.getTargetJavaEE());
                        this.filterJavaEERules(projectsToDetailsFoundAnalyze, rulesAnalyzedByCategory, allFeatures, target, cfvi, this._analyze, libertyJavaEEJakartaFeatures);
                    }
                }
                brr.closeFile();
                serverXml = "";
                serverXmlWritten = false;
                migratedConfig = null;
                if (appConfig != null) {
                    if (appConfig instanceof LibertyServerXml) {
                        File sensitiveDataFile = null;
                        String sensitiveData = null;
                        File jvmOptionsFile = null;
                        String jvmOptions = null;
                        File mimeTypesFile = null;
                        String mimeTypes = null;
                        Map<String, String> filesToMigrate = null;
                        try {
                            LibertyServerXml targetConfig = (LibertyServerXml)appConfig;
                            appConfig.migrateConfig();
                            migratedConfig = targetConfig.getServerXmlContent();
                            sensitiveData = targetConfig.getSensitiveDataContent();
                            sensitiveDataFile = targetConfig.getSensitiveDataXml();
                            mimeTypes = targetConfig.getMimeTypesData();
                            mimeTypesFile = targetConfig.getMimeTypesXml();
                            jvmOptions = targetConfig.getJvmOptionsContent();
                            jvmOptionsFile = targetConfig.getJvmOptions();
                            filesToMigrate = targetConfig.getFilesToMigrate();
                            String serverXmlContent = ServerXmlWriter.buildServerXML(coreFeatures, baseFeatures, migratedConfig, limitFeatures, hasConflicts, null);
                            if (serverXmlContent != null && !serverXmlContent.equals("")) {
                                ReportUtility.writeOutStream(targetConfig.getServerXml(), serverXmlContent);
                                if (sensitiveDataFile != null && sensitiveData != null) {
                                    ReportUtility.writeOutStream(sensitiveDataFile, sensitiveData);
                                    if (SensitiveDataHelper.isIncludeSensitiveData()) {
                                        sensitiveDataFilesSB.append(sensitiveDataFile).append("\n");
                                    }
                                }
                                if (jvmOptionsFile != null && jvmOptions != null) {
                                    ReportUtility.writeOutStream(jvmOptionsFile, jvmOptions);
                                }
                                if (mimeTypesFile != null && mimeTypes != null) {
                                    ReportUtility.writeOutStream(mimeTypesFile, mimeTypes);
                                }
                                this.migrateFilesForConfig(filesToMigrate);
                            }
                        }
                        catch (Exception e) {
                            if (ReportUtility.isDebug()) {
                                ReportUtility.logger.get().log(Level.SEVERE, com.ibm.ws.report.binary.cmdline.Messages.getFormattedMessage(com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScanGenerateConfig_MigratedConfig_Error_Log"), appFile.getName()), e);
                                break block54;
                            }
                            ReportUtility.logger.get().log(Level.SEVERE, com.ibm.ws.report.binary.cmdline.Messages.getFormattedMessage(com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScanGenerateConfig_MigratedConfig_Error"), appFile.getName(), e.getMessage()));
                        }
                    } else {
                        try {
                            WSAdminScript targetConfig = (WSAdminScript)appConfig;
                            targetConfig.migrateConfig();
                            migratedConfig = targetConfig.getWSAdminScriptContent();
                            ReportUtility.writeOutStream(targetConfig.getWSAdminScript(), migratedConfig);
                            if (SensitiveDataHelper.isIncludeSensitiveData() && !SensitiveDataHelper.getRegisteredVarKeys().isEmpty()) {
                                sensitiveDataFilesSB.append(targetConfig.getWSAdminScript()).append("\n");
                            }
                        }
                        catch (Exception e) {
                            if (ReportUtility.isDebug()) {
                                ReportUtility.logger.get().log(Level.SEVERE, com.ibm.ws.report.binary.cmdline.Messages.getFormattedMessage(com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScanGenerateConfig_MigratedConfig_Error_Log"), appFile.getName()), e);
                            }
                            ReportUtility.logger.get().log(Level.SEVERE, com.ibm.ws.report.binary.cmdline.Messages.getFormattedMessage(com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScanGenerateConfig_MigratedConfig_Error"), appFile.getName(), e.getMessage()));
                        }
                    }
                }
            }
            if (isLiberty) {
                try {
                    serverXml = ServerXmlWriter.buildServerXML(coreFeatures, baseFeatures, migratedConfig, limitFeatures, hasConflicts, null);
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                    ReportUtility.logger.get().log(Level.SEVERE, com.ibm.ws.report.binary.cmdline.Messages.getFormattedMessage(com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScanGenerateConfig_NoConfigException"), appFile.getName(), e.getMessage()));
                }
            }
            ReportWriter allWriter = null;
            Map<String, Set<String>> appToRuleDescs = brr._descriptionsForNonTechRulesFlagged;
            List<String> connectivityRulesAnalyzed = this._analyze.getSortedRulesAnalyzedForCategoriesStartingWithPrefix("appconversion.cloud.category.technology.connectivity");
            AnalysisResults analysisResults = new AnalysisResults(this._analyze._descToRuleIds, projectsToDetailsFoundAnalyze, rulesAnalyzedByCategory, connectivityRulesAnalyzed, ruleSeverities, helpFileNames, brr.getRulesFlagged(), _data.showAllHelp(), null, this._analyze.getRulesToRecipesMap());
            for (ReportInputData.OutputType outputType : _data.getOutputType()) {
                switch (outputType) {
                    case HTML: {
                        int targetAppSeverColumnIndex = target != null ? target.getTechColumn(cloud) : -1;
                        TreeMap<String, String> scanOptions = new TreeMap<String, String>();
                        scanOptions.putAll(_data.getScanOptionsDisplay());
                        scanOptions.putAll(_data.getEvalReportOptions(true));
                        String[] sourceOptions = !_data.loadAllRules() ? _data.getSourceOptions() : null;
                        String[] targetOptions = !_data.loadAllRules() ? _data.getTargetOptions() : null;
                        HashSet<String> setOfReports = new HashSet();
                        resultMap.put(outputType, setOfReports);
                        if (_data.generateAllSeparateReports()) {
                            for (int i = 0; i < 3; ++i) {
                                if (i == 0) {
                                    allWriter = new HTMLDetailAnalysisStreamlinedReportWriter(_data.getProjectNames(), _data.getSourceOptions(), _data.getTargetOptions(), _data.getScanOptionsDisplay(), rulesAnalyzedByCategory, false, analysisResults, connectivityRulesAnalyzed, _data.showAllHelp(), _data.loadAllRules(), _data.getMaxUserDefinedRuleResults(), costs);
                                } else if (i == 1) {
                                    allWriter = new HTMLEvaluationReportWriter(_data.getProjectNames(), listOfTechSummaries, _data.getSpecifiedProducts(), _data.getEvalReportOptions(true));
                                } else if (i == 2) {
                                    allWriter = new HTMLInventoryReportWriter(ai, _data.getProjectNames(), sharedLibProjectNames, _data.getScanOptions());
                                }
                                allWriter.writeReport();
                                setOfReports.add(allWriter.getResult());
                            }
                            if (appConfig != null || serverXml == null || serverXml.isEmpty() || serverXmlWritten) break;
                            setOfReports.add(serverXml);
                            serverXmlWritten = true;
                            break;
                        }
                        allWriter = new HTMLMigrationReportWriter(_data.getProjectNames(), listOfTechSummaries, _data.getSpecifiedProducts(), sourceOptions, targetOptions, scanOptions, targetAppSeverColumnIndex, rulesAnalyzedByCategory, analysisResults, connectivityRulesAnalyzed, ai, sharedLibProjectNames, isLiberty, coreFeatures, baseFeatures, serverXml, conflictMessages, hasConflicts, isLibertyCoreTarget, _data.showAllHelp(), _data.loadAllRules(), _data.getMaxUserDefinedRuleResults(), costs);
                        allWriter.writeReport();
                        String output = allWriter.getResult();
                        if (!appToRuleDescs.isEmpty()) {
                            StringBuilder resultBuffer = new StringBuilder();
                            Iterator<String> ruleDescs = appToRuleDescs.get(appToRuleDescs.keySet().iterator().next()).iterator();
                            int index = output.indexOf("</table>", output.indexOf("<li id=\"evaluation"));
                            resultBuffer.append("<p class=\"disclaimer\">");
                            resultBuffer.append(com.ibm.ws.report.binary.cmdline.Messages.getString("DriveScan_Tech_Report_Footnote"));
                            resultBuffer.append("<br>\n");
                            while (ruleDescs.hasNext()) {
                                resultBuffer.append(ruleDescs.next());
                                resultBuffer.append("<br>\n");
                            }
                            resultBuffer.append("</p>\n");
                            int newIndex = index + "</table>".length();
                            output = output.substring(0, newIndex) + resultBuffer.toString() + output.substring(newIndex);
                        }
                        setOfReports.add(output);
                        break;
                    }
                    case JSON: {
                        HashSet<String> setOfReports = new HashSet<String>();
                        resultMap.put(outputType, setOfReports);
                        TreeMap<String, String> JSONScanOptions = new TreeMap<String, String>();
                        JSONScanOptions.putAll(_data.getScanOptionsDisplay());
                        JSONScanOptions.putAll(_data.getEvalReportOptions(false));
                        if (_data.generateAllSeparateReports()) {
                            for (int i = 0; i < 3; ++i) {
                                if (i == 0) {
                                    allWriter = new JSONDetailAnalysisReportWriter(_data.getProjectNames(), _data.getSourceOptions(), _data.getTargetOptions(), _data.getScanOptions(), brr.getProjectsToDetailResults(ReportInputData.ReportType.ANALYZE), rulesAnalyzedByCategory, false, helpFileNames, ruleSeverities, costs, _data.getApplicationNames(), this._analyze.getCategoryNamesMappedToKeys(), _data.includeHelpLocation(), _data.getMaxUserDefinedRuleResults(), analysisResults);
                                } else if (i == 1) {
                                    allWriter = new JSONEvaluationReportWriter(_data.getProjectNames(), listOfTechSummaries, _data.getSpecifiedProducts(), _data.getEvalReportOptions(false), brr._descriptionsForNonTechRulesFlagged);
                                } else if (i == 2) {
                                    allWriter = new JSONInventoryReportWriter(ai, _data.getProjectNames(), sharedLibProjectNames, _data.getScanOptions());
                                }
                                allWriter.writeReport();
                                setOfReports.add(allWriter.getResult());
                            }
                            if (appConfig != null || serverXml == null || serverXml.isEmpty() || serverXmlWritten) break;
                            setOfReports.add(serverXml);
                            serverXmlWritten = true;
                            break;
                        }
                        allWriter = new JSONMigrationReportWriter(_data.getProjectNames(), listOfTechSummaries, _data.getSpecifiedProducts(), JSONScanOptions, _data.getSourceOptions(), _data.getTargetOptions(), projectsToDetailsFoundAnalyze, rulesAnalyzedByCategory, false, helpFileNames, ruleSeverities, costs, ai, sharedLibProjectNames, isLiberty, coreFeatures, baseFeatures, conflictMessages, hasConflicts, appToRuleDescs, this._analyze.getCategoryNamesMappedToKeys(), _data.includeHelpLocation(), _data.getMaxUserDefinedRuleResults(), analysisResults);
                        allWriter.writeReport();
                        setOfReports.add(allWriter.getResult());
                        break;
                    }
                }
            }
            if (analysisResults.containsAutomatedFix()) {
                System.out.println(analysisResults.getAnalysisResultCommandlineOutputString());
            }
        }
        return resultMap;
    }
}

