/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.resource;

import com.ibm.ws.report.binary.configutility.LibertyResource;
import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedObject;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.binary.configutility.resource.AdminObject;
import com.ibm.ws.report.binary.configutility.resource.J2EEResourceFactory;
import com.ibm.ws.report.binary.configutility.resource.J2EEResourceProperty;
import com.ibm.ws.report.binary.configutility.twas.Reference;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.logging.Level;

public class J2CAdminObject
implements ScopedObject,
LibertyResource {
    static final List<String> adminObjectSensitiveProperties = Arrays.asList(new String[0]);
    static final List<String> adminObjectMappedProperties = Arrays.asList(new String[0]);
    private final Scope _scope;
    private final String _name;
    private final String _jndiName;
    private final String _description;
    private final Reference<AdminObject> _adminObjectReference;
    private final SortedMap<String, J2EEResourceProperty> _propertySet;
    private String _resourceAdapterId;
    private final String _libertyId;

    public J2CAdminObject(Scope scope, String name2, String jndiName, String description, SortedMap<String, J2EEResourceProperty> propertySet, Reference<AdminObject> adminObjectReference, String xmiId) {
        this._scope = scope;
        this._name = name2;
        this._jndiName = jndiName;
        this._description = description;
        this._propertySet = propertySet;
        this._adminObjectReference = adminObjectReference;
        this._libertyId = this._name + "_" + xmiId;
        ReportUtility.logger.get().log(Level.FINEST, "Created J2CAdminObject: " + System.getProperty("line.separator") + this);
    }

    public String getName() {
        return this._name;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    @Override
    public String getUniqueIdentifierName() {
        return this._jndiName;
    }

    public String getDescription() {
        return this._description;
    }

    public SortedMap<String, J2EEResourceProperty> getPropertySet() {
        return this._propertySet;
    }

    public Reference<AdminObject> getAdminObject() {
        return this._adminObjectReference;
    }

    @Override
    public Scope getScope() {
        return this._scope;
    }

    public void setResourceAdapterId(String raID) {
        this._resourceAdapterId = raID;
    }

    public String getResourceAdapterId() {
        return this._resourceAdapterId;
    }

    @Override
    public String getLibertyId() {
        if (this._libertyId == null) {
            return this._name;
        }
        return this._libertyId;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("J2CAdminObject: name=\"" + this._name + "\"" + nl);
        sb.append("libertyId=\"" + this._libertyId + "\"" + nl);
        sb.append("jndiName=\"" + this._jndiName + "\"" + nl);
        sb.append("description=\"" + this._description + "\"" + nl);
        sb.append("scope=\"" + this._scope + "\"" + nl);
        sb.append("adminObjectReference=\"" + this._adminObjectReference + "\"" + nl);
        sb.append("Properties: " + nl);
        if (this._propertySet != null) {
            for (J2EEResourceProperty prop : this._propertySet.values()) {
                sb.append(prop + nl);
            }
        }
        return sb.toString();
    }

    @Override
    public boolean equalsAllowDifferentScopes(ScopedObject entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof J2CAdminObject)) {
            return false;
        }
        J2CAdminObject admin = (J2CAdminObject)entry;
        return CommonUtilities.equals(this._name, admin.getName()) && CommonUtilities.equals(this._jndiName, admin.getJndiName()) && CommonUtilities.equals(this._description, admin.getDescription()) && CommonUtilities.equals(this._adminObjectReference, admin.getAdminObject()) && CommonUtilities.equals(this._propertySet, admin.getPropertySet());
    }

    static {
        String jeeResourceType = J2CAdminObject.class.getCanonicalName();
        J2EEResourceFactory.registerPropertiesForJEEResourceType(jeeResourceType, adminObjectSensitiveProperties, adminObjectMappedProperties);
    }
}

