/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.resource;

import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedObject;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.binary.configutility.resource.Connector;
import com.ibm.ws.report.binary.configutility.resource.J2CActivationSpec;
import com.ibm.ws.report.binary.configutility.resource.J2CAdminObject;
import com.ibm.ws.report.binary.configutility.resource.J2CConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.J2EEResourceProperty;
import com.ibm.ws.report.binary.configutility.resource.J2EEResourceProvider;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.List;
import java.util.SortedMap;
import java.util.logging.Level;

public class J2CResourceAdapter
extends J2EEResourceProvider
implements ScopedObject {
    private final Scope _scope;
    private final String _archivePath;
    private final String _threadPoolAlias;
    private final String _singleton;
    private final String _hACapability;
    private final String _isEnableHASupport;
    private final SortedMap<String, J2CAdminObject> _j2cAdminObjects;
    private final SortedMap<String, J2CActivationSpec> _j2cActivationSpec;
    private final Connector _deploymentDescriptor;

    public J2CResourceAdapter(Scope scope, String name2, String description, List<String> classpath, List<String> nativepath, String providerType, String isolatedClassLoader, SortedMap<String, J2CConnectionFactory> factories, SortedMap<String, J2EEResourceProperty> propertySet, String archivePath, String threadPoolAlias, String singleton, String hACapability, String isEnableHASupport, SortedMap<String, J2CAdminObject> j2cAdminObjects, SortedMap<String, J2CActivationSpec> j2cActivationSpec, Connector deploymentDescriptor) {
        super(name2, description, classpath, nativepath, providerType, isolatedClassLoader, factories, propertySet);
        this._scope = scope;
        this._archivePath = archivePath;
        this._threadPoolAlias = threadPoolAlias;
        this._singleton = singleton;
        this._hACapability = hACapability;
        this._isEnableHASupport = isEnableHASupport;
        this._j2cAdminObjects = j2cAdminObjects;
        this._j2cActivationSpec = j2cActivationSpec;
        this._deploymentDescriptor = deploymentDescriptor;
        ReportUtility.logger.get().log(Level.FINEST, "Created J2CResourceAdapter: " + System.getProperty("line.separator") + this);
    }

    @Override
    public String getUniqueIdentifierName() {
        return super.getName();
    }

    public SortedMap<String, J2CConnectionFactory> getFactories() {
        return super.getFactories();
    }

    public String getArchivePath() {
        return this._archivePath;
    }

    public String getThreadPoolAlias() {
        return this._threadPoolAlias;
    }

    public String getSingleton() {
        return this._singleton;
    }

    public String getHACapability() {
        return this._hACapability;
    }

    public String getIsEnableHASupport() {
        return this._isEnableHASupport;
    }

    public SortedMap<String, J2CAdminObject> getJ2cAdminObjects() {
        return this._j2cAdminObjects;
    }

    public SortedMap<String, J2CActivationSpec> getJ2cActivationSpec() {
        return this._j2cActivationSpec;
    }

    public Connector getDeploymentDescriptor() {
        return this._deploymentDescriptor;
    }

    @Override
    public Scope getScope() {
        return this._scope;
    }

    @Override
    public boolean equalsAllowDifferentScopes(ScopedObject entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof J2CResourceAdapter)) {
            return false;
        }
        J2CResourceAdapter adapter = (J2CResourceAdapter)entry;
        return CommonUtilities.equals(super.getName(), adapter.getName()) && CommonUtilities.equals(super.getDescription(), adapter.getDescription()) && CommonUtilities.equals(super.getClasspath(), adapter.getClasspath()) && CommonUtilities.equals(super.getNativepath(), adapter.getNativepath()) && CommonUtilities.equals(super.getProviderType(), adapter.getProviderType()) && CommonUtilities.equals(super.getIsolatedClassLoader(), adapter.getIsolatedClassLoader()) && CommonUtilities.equals(super.getPropertySet(), adapter.getPropertySet()) && CommonUtilities.equals(this._archivePath, adapter.getArchivePath()) && CommonUtilities.equals(this._threadPoolAlias, adapter.getThreadPoolAlias()) && CommonUtilities.equals(this._singleton, adapter.getSingleton()) && CommonUtilities.equals(this._hACapability, adapter.getHACapability()) && CommonUtilities.equals(this._isEnableHASupport, adapter.getIsEnableHASupport()) && CommonUtilities.equals(this._deploymentDescriptor, adapter.getDeploymentDescriptor());
    }

    @Override
    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("J2CResourceAdapter: " + nl);
        sb.append("superclass: " + super.toString() + nl);
        sb.append("archivePath=\"" + this._archivePath + "\"" + nl);
        sb.append("threadPoolAlias=\"" + this._threadPoolAlias + "\"" + nl);
        sb.append("singleton=\"" + this._singleton + "\"" + nl);
        sb.append("hACapability=\"" + this._hACapability + "\"" + nl);
        sb.append("isEnableHASupport=\"" + this._isEnableHASupport + "\"" + nl);
        sb.append("scope=\"" + this._scope + "\"" + nl);
        sb.append("j2cAdminObjects=\"" + (this._j2cAdminObjects != null ? this._j2cAdminObjects.keySet() : null) + "\"" + nl);
        sb.append("j2cActivationSpec=\"" + (this._j2cActivationSpec != null ? this._j2cActivationSpec.keySet() : null) + "\"" + nl);
        sb.append("deploymentDescriptor=\"" + this._deploymentDescriptor + "\"" + nl);
        return sb.toString();
    }
}

