/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.resource;

import com.ibm.ws.report.binary.configutility.LibertyResource;
import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedObject;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.List;
import java.util.logging.Level;

public class JNDIObjectFactory
implements ScopedObject,
LibertyResource {
    private final Scope _scope;
    private final String _id;
    private final String _xmiId;
    private final String _libertyId;
    private final List<String> _classpath;
    private final String _factoryClassName;
    private final String _objectClassName;

    public JNDIObjectFactory(Scope scope, String xmiId, String id, List<String> classpath, String factoryClassName, String objectClassName) {
        this._scope = scope;
        this._xmiId = xmiId;
        this._id = id;
        this._libertyId = id + "_" + xmiId;
        this._classpath = classpath;
        this._factoryClassName = factoryClassName;
        this._objectClassName = objectClassName;
        ReportUtility.logger.get().log(Level.FINEST, "Created JNDIBinding: " + System.getProperty("line.separator") + this);
    }

    @Override
    public Scope getScope() {
        return this._scope;
    }

    public String getId() {
        return this._id;
    }

    public List<String> getClassPath() {
        return this._classpath;
    }

    public String getFactoryClassName() {
        return this._factoryClassName;
    }

    public String getObjectClassName() {
        return this._objectClassName;
    }

    @Override
    public String getUniqueIdentifierName() {
        return this._id;
    }

    @Override
    public boolean equalsAllowDifferentScopes(ScopedObject entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof JNDIObjectFactory)) {
            return false;
        }
        JNDIObjectFactory jb = (JNDIObjectFactory)entry;
        return CommonUtilities.equals(this._id, jb.getId());
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("JNDIBinding: " + nl);
        sb.append("scope=\"" + this._scope + "\"" + nl);
        sb.append("id=\"" + this._id + "\"" + nl);
        sb.append("classpath=\"" + this._classpath + "\"" + nl);
        sb.append("factoryClassName=\"" + this._factoryClassName + "\"" + nl);
        sb.append("xmiId=\"" + this._xmiId + "\"" + nl);
        return sb.toString();
    }

    @Override
    public String getLibertyId() {
        return this._libertyId;
    }
}

