/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.security;

import com.ibm.ws.report.binary.configutility.mutableconfig.SensitiveData;
import com.ibm.ws.report.binary.configutility.security.LDAPSearchFilter;
import com.ibm.ws.report.binary.configutility.security.UserRegistry;
import com.ibm.ws.report.binary.configutility.server.EndPoint;
import com.ibm.ws.report.binary.configutility.server.Property;
import java.util.List;

public class LDAPUserRegistry
extends UserRegistry {
    private final String _type;
    private final String _baseDN;
    private final SensitiveData _bindDN;
    private final SensitiveData _bindPassword;
    private final String _reuseConnection;
    private final String _searchTimeout;
    private final String _sslEnabled;
    private final String _sslConfig;
    private final String _monitorInterval;
    private final LDAPSearchFilter _searchFilter;
    private final List<EndPoint> _hosts;

    public LDAPUserRegistry(String id, String realm, String type, String baseDN, String bindDN, String bindPassword, String ignoreCase, String reuseConnection, String searchTimeout, String sslEnabled, String sslConfig, String monitorInterval, List<EndPoint> hosts, List<Property> properties, LDAPSearchFilter searchFilter, String serverId, String serverPassword, String limit, String useRegistryServerId, String primaryAdminId, String useRegistryRealm, String cellName) {
        super(id, realm, ignoreCase, properties, serverId, serverPassword, limit, useRegistryServerId, primaryAdminId, useRegistryRealm, cellName);
        this._type = type;
        this._baseDN = baseDN;
        this._bindDN = "".equals(bindDN) ? null : new SensitiveData(this.getLibertyId() + "_ldapRegistry_bindDN", bindDN);
        this._bindPassword = "".equals(bindPassword) || "{xor}".equals(bindPassword) ? null : new SensitiveData(this.getLibertyId() + "_ldapRegistry_bindPassword", bindPassword);
        this._reuseConnection = reuseConnection;
        this._searchTimeout = searchTimeout;
        this._sslEnabled = sslEnabled;
        this._sslConfig = sslConfig;
        this._monitorInterval = monitorInterval;
        this._searchFilter = searchFilter;
        this._hosts = hosts;
    }

    public String getType() {
        return this._type;
    }

    public String getBaseDN() {
        return this._baseDN;
    }

    public SensitiveData getBindDN() {
        return this._bindDN;
    }

    public SensitiveData getBindPassword() {
        return this._bindPassword;
    }

    public String getReuseConnection() {
        return this._reuseConnection;
    }

    public String getSearchTimeout() {
        return this._searchTimeout;
    }

    public String getSslEnabled() {
        return this._sslEnabled;
    }

    public String getSslConfig() {
        return this._sslConfig;
    }

    public String getMonitorInterval() {
        return this._monitorInterval;
    }

    public LDAPSearchFilter getSearchFilter() {
        return this._searchFilter;
    }

    public List<EndPoint> getHosts() {
        return this._hosts;
    }

    @Override
    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("LDAPUserRegistry: " + nl);
        sb.append("superclass: " + super.toString() + nl);
        sb.append("type=\"" + this._type + "\"" + nl);
        sb.append("baseDN=\"" + this._baseDN + "\"" + nl);
        sb.append("bindDN=\"******\"" + nl);
        sb.append("bindPassword=\"******\"" + nl);
        sb.append("reuseConnection=\"" + this._reuseConnection + "\"" + nl);
        sb.append("searchTimeout=\"" + this._searchTimeout + "\"" + nl);
        sb.append("sslEnabled=\"" + this._sslEnabled + "\"" + nl);
        sb.append("sslConfig=\"" + this._sslConfig + "\"" + nl);
        sb.append("monitorInterval=\"" + this._monitorInterval + "\"" + nl);
        sb.append("searchFilter=\"" + this._searchFilter + "\"" + nl);
        sb.append("hosts=\"" + this._hosts + "\"" + nl);
        return sb.toString();
    }
}

