/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.server;

import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedObject;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.binary.configutility.server.Property;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.List;
import java.util.logging.Level;

public class WebContainer
implements ScopedObject {
    private final Scope _scope;
    private final List<Property> _properties;

    public WebContainer(Scope scope, List<Property> properties) {
        this._scope = scope;
        this._properties = properties;
        ReportUtility.logger.get().log(Level.FINEST, "Created WebContainer: " + System.getProperty("line.separator") + this);
    }

    public List<Property> getProperties() {
        return this._properties;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("WebContainer: " + nl);
        if (this._properties != null) {
            for (Property prop : this._properties) {
                sb.append(prop + nl);
            }
        }
        return sb.toString();
    }

    @Override
    public Scope getScope() {
        return this._scope;
    }

    @Override
    public String getUniqueIdentifierName() {
        return "WebContainer";
    }

    @Override
    public boolean equalsAllowDifferentScopes(ScopedObject entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof WebContainer)) {
            return false;
        }
        WebContainer sm = (WebContainer)entry;
        boolean returnValue = CommonUtilities.equals(this._properties, sm.getProperties());
        return returnValue;
    }
}

