/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.AnnotationInfo;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class DetectAnnotation
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected String[] classNames = null;
    protected boolean isPublic = false;
    protected String attributeName = null;
    protected String attributeType = null;
    protected String[] attributeValues = null;
    protected String defaultValue = null;
    protected String accessFlag = null;
    protected String location = null;
    protected String defaultName = null;
    protected String missingAttributeName = null;
    protected String locationClass = null;

    public DetectAnnotation(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        this(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE, false, location, defaultName, missingAttributeName, null);
    }

    public DetectAnnotation(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName, String locationClass) {
        this(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE, false, location, defaultName, missingAttributeName, locationClass);
    }

    public DetectAnnotation(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, DetectRule.FlagOnce flagOnceType, boolean hideResult, String location, String defaultName, String missingAttributeName, String locationClass) {
        super(ruleName, desc, flagOnceType, hideResult);
        this.classNames = classNames;
        this.attributeName = attributeName;
        this.attributeType = attributeType;
        this.attributeValues = attributeValues;
        this.defaultValue = defaultValue;
        this.accessFlag = accessFlag;
        this.location = location;
        this.defaultName = defaultName;
        this.missingAttributeName = missingAttributeName;
        this.locationClass = locationClass;
    }

    @Override
    public String[] getAnnotations() {
        return this.classNames;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        if (detectOnce && !this.detailResults.isEmpty()) {
            return;
        }
        Set<String> keys = store.getClassDataStoreKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                if (!this.shouldFlag(key)) continue;
                ClassDataStore data = store.getClassDataStore(key);
                String[] stringArray = this.classNames;
                int n = this.classNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String className = stringArray[n2];
                    if (data.containsAnnotation(className)) {
                        List<AnnotationDetails> ads = data.getAnnotationDetails(className);
                        for (AnnotationDetails ad : ads) {
                            String ref;
                            if (!this.validLocation(data, ad)) continue;
                            if (this.missingAttributeName != null) {
                                if (ad.containsAttributeName(this.missingAttributeName)) continue;
                                ref = ad.getReference();
                                if (ref == null) {
                                    ref = ad.getReferenceTypeDescription();
                                } else if (ref.contains("<init>")) {
                                    ref = Messages.getString("Report_Reference_Constructor");
                                } else if (ref.contains("<clinit>")) {
                                    ref = Messages.getString("Report_Reference_Static_Initializer");
                                }
                                if (this.flag(key)) {
                                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, className, 1, ref, ad.getLineNumber()));
                                }
                                if (!detectOnce && !this.flagOnce) continue;
                                return;
                            }
                            if (this.attributeType == null) {
                                if (!this.includeInResults(key, data, ad)) continue;
                                ref = ad.getReference();
                                if (ref == null) {
                                    ref = ad.getReferenceTypeDescription();
                                } else if (ref.contains("<init>")) {
                                    ref = Messages.getString("Report_Reference_Constructor");
                                } else if (ref.contains("<clinit>")) {
                                    ref = Messages.getString("Report_Reference_Static_Initializer");
                                }
                                if (this.flag(key)) {
                                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, className, 1, ref, ad.getLineNumber()));
                                }
                                if (!detectOnce && !this.flagOnce) continue;
                                return;
                            }
                            Set<AnnotationInfo> ais = ad.getAnnotationInformation(this.attributeType);
                            if (ais.size() == 0) {
                                if (this.defaultValue == null) continue;
                                String desc = Messages.getFormattedMessage(Messages.getString("Report_Criteria_Plus_Value"), className, this.defaultValue);
                                String ref2 = ad.getReference();
                                if (ref2 == null) {
                                    ref2 = ad.getReferenceTypeDescription();
                                } else if (ref2.contains("<init>")) {
                                    ref2 = Messages.getString("Report_Reference_Constructor");
                                } else if (ref2.contains("<clinit>")) {
                                    ref2 = Messages.getString("Report_Reference_Static_Initializer");
                                }
                                if (this.flag(key)) {
                                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, desc, 1, ref2, ad.getLineNumber()));
                                }
                                if (!detectOnce && !this.flagOnce) continue;
                                return;
                            }
                            for (AnnotationInfo ai : ais) {
                                if (!ai.matches(this.attributeName, this.attributeType, this.attributeValues) || !this.includeInResults(key, data, ai)) continue;
                                String desc = Messages.getFormattedMessage(Messages.getString("Report_Criteria_Plus_Value"), className, String.valueOf(ai.getAttributeName()) + "=" + ai.getAttributeValue());
                                String ref3 = ai.getReference();
                                if (ref3.contains("<init>")) {
                                    ref3 = Messages.getString("Report_Reference_Constructor");
                                } else if (ref3.contains("<clinit>")) {
                                    ref3 = Messages.getString("Report_Reference_Static_Initializer");
                                }
                                if (this.flag(key)) {
                                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, desc, 1, ai.getReference(), ai.getLineNumber()));
                                }
                                if (!detectOnce && !this.flagOnce) continue;
                                return;
                            }
                        }
                    } else if (this.location != null && this.defaultName != null && this.defaultValue != null && this.validLocation(data, null) && data.getClassName().matches(this.defaultName)) {
                        if (this.flag(key)) {
                            this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, this.defaultName, 1, Messages.getFormattedMessage(Messages.getString("Report_Reference_Default_Annotation"), className), 0));
                        }
                        if (detectOnce || this.flagOnce) {
                            return;
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
        return true;
    }

    protected boolean includeInResults(String key, ClassDataStore data, AnnotationInfo ai) {
        return true;
    }

    protected boolean validLocation(ClassDataStore data, AnnotationDetails ad) {
        boolean flag = false;
        if (this.accessFlag == null || this.accessFlag.equals("non-public") && !data.isPublic() || this.accessFlag.equals("public") && data.isPublic()) {
            if (this.location == null) {
                flag = true;
            } else if (this.location.equals("class")) {
                if (!(data.isInterface() || ad != null && ad.getReferenceType() != 0)) {
                    flag = true;
                }
            } else if (this.location.equals("interface")) {
                if (data.isInterface() && (ad == null || ad.getReferenceType() == 4)) {
                    flag = true;
                }
            } else if (this.location.equals("method")) {
                if (ad != null && ad.getReferenceType() == 1) {
                    flag = true;
                }
            } else if (this.location.equals("field") && ad != null && ad.getReferenceType() == 2) {
                if (this.locationClass == null) {
                    flag = true;
                } else {
                    String locClass = ad.getLocationClass();
                    if (locClass != null && locClass.matches(this.locationClass)) {
                        flag = true;
                    }
                }
            }
        }
        return flag;
    }
}

