/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.Rule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;

public class DetectMultipleCriteria
extends DetectRule {
    protected EnumSet<RuleType> _ruleType = EnumSet.noneOf(RuleType.class);
    protected List<Rule> _rules = null;
    protected LogicType _logicType = null;
    protected boolean isRoot;
    protected boolean resultsHidden = false;

    public DetectMultipleCriteria(String ruleName, String desc, List<Rule> rules, boolean flagOnce, boolean isRoot) {
        this(ruleName, desc, rules, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE, LogicType.OR, false, isRoot);
    }

    public DetectMultipleCriteria(String ruleName, String desc, List<Rule> rules, DetectRule.FlagOnce flagOnceType, LogicType logicType, boolean hideResult, boolean isRoot) {
        super(ruleName, desc, flagOnceType, hideResult);
        this._rules = rules == null ? new ArrayList<Rule>() : rules;
        for (Rule rule : rules) {
            this._ruleType.addAll(rule.getRuleTypes());
        }
        this._logicType = logicType;
        this.isRoot = isRoot;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return this._ruleType;
    }

    public List<Rule> getRules() {
        return this._rules;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        for (Rule nextRule : this._rules) {
            nextRule.clearResults();
        }
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        for (Rule nextRule : this._rules) {
            List<DetailResult> results = nextRule.getResults(store);
            if (!results.isEmpty()) {
                if (!nextRule.shouldHideResult()) {
                    if (this.flagOnce) {
                        if (this.flagOnceType == DetectRule.FlagOnce.ARCHIVE && this.modulesFlagged.isEmpty()) {
                            this.modulesFlagged.addAll(nextRule.getModulesFlagged());
                            this.detailResults.addAll(results);
                        } else if (this.flagOnceType == DetectRule.FlagOnce.FILE && this.filesFlagged.isEmpty()) {
                            this.filesFlagged.addAll(nextRule.getFilesFlagged());
                            this.detailResults.addAll(results);
                        } else {
                            for (DetailResult nextResult : results) {
                                if (!this.flag(nextResult.getFileName())) continue;
                                this.detailResults.add(nextResult);
                            }
                        }
                    } else {
                        this.detailResults.addAll(results);
                    }
                } else {
                    this.resultsHidden = true;
                }
            } else if (this._logicType == LogicType.AND) {
                this.modulesFlagged.clear();
                this.detailResults.clear();
                break;
            }
            if (!(nextRule instanceof DetectMultipleCriteria) || !((DetectMultipleCriteria)nextRule).resultsHidden) continue;
            this.resultsHidden = true;
        }
        if (this.resultsHidden && this.isRoot && this.detailResults.isEmpty()) {
            this.detailResults.add(new DetailResult(this.ruleName, "", this.ruleDescription, Messages.getString("Report_Has_Hidden_Results")));
        }
        return this.detailResults;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce, RuleType type) {
        for (Rule nextRule : this._rules) {
            if (type != null && !nextRule.getRuleTypes().contains((Object)type)) continue;
            try {
                nextRule.analyze(store, detectOnce);
            }
            catch (Exception e) {
                if (ReportUtility.isDebug()) {
                    ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_Error_Processing_Rule_Log"), nextRule.getRuleDescription()), e);
                    continue;
                }
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_Error_Processing_Rule"), nextRule.getRuleDescription(), e.toString()));
            }
        }
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this.analyze(store, detectOnce, null);
    }

    public static enum LogicType {
        OR,
        AND;

    }
}

