/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageOccurrence;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class DetectPackage
extends DetectRule {
    protected EnumSet<RuleType> _ruleType = EnumSet.noneOf(RuleType.class);
    protected String[] packageNames = null;
    protected boolean useAppProvidedLibraries = false;
    protected boolean skipScanForUsage = false;
    protected String[] excludeClassNames = null;
    protected String[] excludePackageNames = null;
    protected String[] providedPackageNames = null;
    protected boolean detectProvidedAndUsed = false;
    protected String excludeReferences = null;
    protected TreeMap<String, Integer> hitsPerReference = new TreeMap();
    protected Map<String, String> classNameToNameWithContext = new HashMap<String, String>();

    public DetectPackage(String ruleName, String desc, String[] packageNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, String[] excludeClassNames, String[] excludePackageNames, boolean flagOnce) {
        this(ruleName, desc, packageNames, useAppProvidedLibraries, skipScanForUsage, excludeClassNames, excludePackageNames, flagOnce, false, null, null);
    }

    public DetectPackage(String ruleName, String desc, String[] packageNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, String[] excludeClassNames, String[] excludePackageNames, DetectRule.FlagOnce flagOnceType) {
        this(ruleName, desc, packageNames, useAppProvidedLibraries, skipScanForUsage, excludeClassNames, excludePackageNames, flagOnceType, false, false, null, null);
    }

    public DetectPackage(String ruleName, String desc, String[] packageNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, String[] excludeClassNames, String[] excludePackageNames, boolean flagOnce, boolean providedAndUsed, String[] providedPackageNames, String excludeReferences) {
        this(ruleName, desc, packageNames, useAppProvidedLibraries, skipScanForUsage, excludeClassNames, excludePackageNames, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE, false, providedAndUsed, providedPackageNames, excludeReferences);
    }

    public DetectPackage(String ruleName, String desc, String[] packageNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, String[] excludeClassNames, String[] excludePackageNames, DetectRule.FlagOnce flagOnceType, boolean hideResult, boolean providedAndUsed, String[] providedPackageNames, String excludeReferences) {
        super(ruleName, desc, flagOnceType, hideResult);
        this.packageNames = packageNames;
        this.useAppProvidedLibraries = useAppProvidedLibraries;
        this.skipScanForUsage = skipScanForUsage;
        this.excludeClassNames = excludeClassNames;
        this.excludePackageNames = excludePackageNames;
        this.providedPackageNames = providedPackageNames;
        this.detectProvidedAndUsed = providedAndUsed;
        this.excludeReferences = excludeReferences;
        this._ruleType.add(RuleType.JavaRule);
    }

    public String[] getPackageNames() {
        return this.packageNames;
    }

    public String[] getExcludeClassNames() {
        return this.excludeClassNames;
    }

    protected List<String> getRelevantPackageNamesToExclude(String packageName) {
        ArrayList<String> names = null;
        if (packageName.endsWith("*") && this.excludePackageNames != null) {
            String comparePackageName = packageName.replace('*', '.');
            String[] stringArray = this.excludePackageNames;
            int n = this.excludePackageNames.length;
            int n2 = 0;
            while (n2 < n) {
                String excludeName = stringArray[n2];
                if (excludeName.startsWith(comparePackageName)) {
                    if (names == null) {
                        names = new ArrayList<String>();
                    }
                    names.add(excludeName);
                }
                ++n2;
            }
        }
        return names;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return this._ruleType;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.classNameToNameWithContext.clear();
        this.hitsPerReference.clear();
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        if (!this.hitsPerReference.isEmpty()) {
            TreeMap<String, Integer> referencedClasses = new TreeMap<String, Integer>((SortedMap<String, Integer>)this.hitsPerReference);
            for (DetailResult result : this.detailResults) {
                result.setReferencedClasses(referencedClasses);
            }
        }
        if (this.skipScanForUsage) {
            boolean allPackagesFound = true;
            String[] stringArray = this.packageNames;
            int n = this.packageNames.length;
            int n2 = 0;
            while (n2 < n) {
                String packageName = stringArray[n2];
                if (!this.useAppProvidedLibraries || !store.containsImplementedPackageName(packageName)) {
                    allPackagesFound = false;
                    break;
                }
                this.detailResults.add(new DetailResult(this.ruleName, Messages.getString("Report_File_Name_Unavailable"), this.ruleDescription, packageName));
                ++n2;
            }
            if (!allPackagesFound) {
                this.detailResults.clear();
            }
        } else if (!this.detailResults.isEmpty()) {
            if (this.detectProvidedAndUsed) {
                DetailResult validReference = null;
                if (this.excludeReferences != null) {
                    for (DetailResult nextResult : this.detailResults) {
                        String ref = nextResult.getFileName();
                        if (ref == null || ref.matches(this.excludeReferences)) continue;
                        validReference = nextResult;
                        break;
                    }
                } else {
                    validReference = (DetailResult)this.detailResults.get(0);
                }
                if (validReference == null) {
                    this.detailResults.clear();
                } else {
                    String[] packagesToValidate = this.providedPackageNames;
                    if (packagesToValidate == null) {
                        packagesToValidate = this.packageNames;
                    }
                    boolean allPackagesFound = true;
                    String[] stringArray = packagesToValidate;
                    int n = packagesToValidate.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String packageName = stringArray[n3];
                        if (!store.containsImplementedPackageName(packageName)) {
                            allPackagesFound = false;
                            break;
                        }
                        ++n3;
                    }
                    if (allPackagesFound) {
                        ArrayList<DetailResult> newResults = new ArrayList<DetailResult>();
                        validReference.setNumberOfOccurrences(1);
                        newResults.add(validReference);
                        return newResults;
                    }
                    this.detailResults.clear();
                }
            } else if (this.useAppProvidedLibraries || this.flagOnce) {
                ArrayList<DetailResult> newResults = new ArrayList<DetailResult>();
                ReportUtility.sortDetailResults(this.detailResults);
                if (this.useAppProvidedLibraries) {
                    for (DetailResult result : this.detailResults) {
                        String criteria = result.getCriteria();
                        if (store.containsImplementedPackageName(criteria) || !this.flag(result.getFileName())) continue;
                        if (this.flagOnce) {
                            result.setNumberOfOccurrences(1);
                        }
                        newResults.add(result);
                    }
                } else if (this.flagOnce) {
                    for (DetailResult result : this.detailResults) {
                        if (!this.flag(result.getFileName())) continue;
                        result.setNumberOfOccurrences(1);
                        newResults.add(result);
                    }
                }
                return newResults;
            }
        }
        return this.detailResults;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        block34: {
            Set<String> keys;
            block35: {
                if (this.skipScanForUsage) break block34;
                if (!detectOnce || this.excludePackageNames != null) break block35;
                String[] stringArray = this.packageNames;
                int n = this.packageNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String packageName = stringArray[n2];
                    if (store.containsPackageName(packageName) && (!this.useAppProvidedLibraries || this.useAppProvidedLibraries && !store.containsImplementedPackageName(packageName))) {
                        this.detailResults.add(new DetailResult(this.ruleName, Messages.getString("Report_File_Name_Unavailable"), this.ruleDescription, packageName));
                    }
                    ++n2;
                }
                break block34;
            }
            if (detectOnce && this.excludePackageNames != null) {
                this.flagOnce = true;
            }
            if ((keys = store.getClassDataStoreKeys()).isEmpty()) break block34;
            for (String key : keys) {
                ClassDataStore data = store.getClassDataStore(key);
                String[] stringArray = this.packageNames;
                int n = this.packageNames.length;
                int n3 = 0;
                while (n3 < n) {
                    String packageName = stringArray[n3];
                    if (data.containsPackageName(packageName) && (!this.useAppProvidedLibraries || this.useAppProvidedLibraries && !store.containsImplementedPackageName(packageName))) {
                        ClassOrPackageDetails[] pds = data.getPackageDetails(packageName);
                        List<String> excludeThesePackageNames = this.getRelevantPackageNamesToExclude(packageName);
                        pds = data.getPackageDetails(packageName, excludeThesePackageNames);
                        if (pds != null) {
                            ClassOrPackageDetails[] classOrPackageDetailsArray = pds;
                            int n4 = pds.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                ClassOrPackageDetails pd = classOrPackageDetailsArray[n5];
                                this.classNameToNameWithContext.put(key, data.getClassNameWithContext());
                                String thisPackageName = pd.getClassOrPackageName();
                                Set<String> classesToExclude = this.getClassesToExclude(thisPackageName);
                                if (classesToExclude.size() > 0) {
                                    pd = this.getNewPackageDetails(pd, classesToExclude);
                                }
                                if (pd != null) {
                                    Map<String, ClassOrPackageOccurrence> info = pd.getReferenceAndLineInfo();
                                    Set<String> methodKeys = info.keySet();
                                    ArrayList<String> sortedKeys = new ArrayList<String>(methodKeys);
                                    Collections.sort(sortedKeys);
                                    int numKeys = sortedKeys.size();
                                    int i = 0;
                                    while (i < numKeys) {
                                        String methodKey;
                                        String reference = methodKey = (String)sortedKeys.get(i);
                                        if (methodKey.contains("<init>")) {
                                            reference = Messages.getString("Report_Reference_Constructor");
                                        } else if (methodKey.contains("<clinit>")) {
                                            reference = Messages.getString("Report_Reference_Static_Initializer");
                                        }
                                        ClassOrPackageOccurrence copo = info.get(methodKey);
                                        this.addReferenceHits(copo.getLineNumberClassNames());
                                        List<Integer> sortedLines = copo.getLineNumbers();
                                        Collections.sort(sortedLines);
                                        int numLines = sortedLines.size();
                                        int numLineOccurrences = 0;
                                        int lastLineNumber = 0;
                                        boolean lastLineNumberSet = false;
                                        int j = 0;
                                        while (j < numLines) {
                                            Integer lineNumber = sortedLines.get(j);
                                            int thisLineNumber = lineNumber;
                                            if (lastLineNumberSet && thisLineNumber == lastLineNumber) {
                                                ++numLineOccurrences;
                                            } else if (lastLineNumberSet) {
                                                if (lastLineNumber == 0 && (copo.getReturnTypeOccurrences() > 0 || copo.getAnnotationOccurrences() > 0 || copo.getCatchExceptionOccurrences() > 0 || copo.getThrowsExceptionOccurrences() > 0 || copo.getParameterOccurrences() > 0)) {
                                                    int numOccurrences;
                                                    String desc;
                                                    if (copo.getReturnTypeOccurrences() > 0) {
                                                        desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(1));
                                                        numOccurrences = copo.getReturnTypeOccurrences();
                                                        this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, thisPackageName, numOccurrences, desc, lastLineNumber));
                                                    }
                                                    if (copo.getAnnotationOccurrences() > 0) {
                                                        desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(2));
                                                        numOccurrences = copo.getAnnotationOccurrences();
                                                        this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, thisPackageName, numOccurrences, desc, lastLineNumber));
                                                    }
                                                    if (copo.getCatchExceptionOccurrences() > 0) {
                                                        desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(6));
                                                        numOccurrences = copo.getCatchExceptionOccurrences();
                                                        this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, thisPackageName, numOccurrences, desc, lastLineNumber));
                                                    }
                                                    if (copo.getThrowsExceptionOccurrences() > 0) {
                                                        desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(5));
                                                        numOccurrences = copo.getThrowsExceptionOccurrences();
                                                        this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, thisPackageName, numOccurrences, desc, lastLineNumber));
                                                    }
                                                    if (copo.getParameterOccurrences() > 0) {
                                                        desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(3));
                                                        numOccurrences = copo.getParameterOccurrences();
                                                        this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, thisPackageName, numOccurrences, desc, lastLineNumber));
                                                    }
                                                } else {
                                                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, thisPackageName, numLineOccurrences, reference, lastLineNumber));
                                                }
                                                lastLineNumber = thisLineNumber;
                                                numLineOccurrences = 1;
                                            } else {
                                                lastLineNumberSet = true;
                                                lastLineNumber = thisLineNumber;
                                                numLineOccurrences = 1;
                                            }
                                            ++j;
                                        }
                                        if (lastLineNumberSet) {
                                            if (lastLineNumber == 0 && (copo.getReturnTypeOccurrences() > 0 || copo.getAnnotationOccurrences() > 0 || copo.getCatchExceptionOccurrences() > 0 || copo.getThrowsExceptionOccurrences() > 0 || copo.getParameterOccurrences() > 0)) {
                                                if (copo.getReturnTypeOccurrences() > 0) {
                                                    String desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(1));
                                                    int numOccurrences = copo.getReturnTypeOccurrences();
                                                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, thisPackageName, numOccurrences, desc, lastLineNumber));
                                                }
                                                if (copo.getAnnotationOccurrences() > 0) {
                                                    String desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(2));
                                                    int numOccurrences = copo.getAnnotationOccurrences();
                                                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, thisPackageName, numOccurrences, desc, lastLineNumber));
                                                }
                                                if (copo.getCatchExceptionOccurrences() > 0) {
                                                    String desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(6));
                                                    int numOccurrences = copo.getCatchExceptionOccurrences();
                                                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, thisPackageName, numOccurrences, desc, lastLineNumber));
                                                }
                                                if (copo.getThrowsExceptionOccurrences() > 0) {
                                                    String desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(5));
                                                    int numOccurrences = copo.getThrowsExceptionOccurrences();
                                                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, thisPackageName, numOccurrences, desc, lastLineNumber));
                                                }
                                                if (copo.getParameterOccurrences() > 0) {
                                                    String desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(3));
                                                    int numOccurrences = copo.getParameterOccurrences();
                                                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, thisPackageName, numOccurrences, desc, lastLineNumber));
                                                }
                                            } else {
                                                this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, thisPackageName, numLineOccurrences, reference, lastLineNumber));
                                            }
                                        }
                                        ++i;
                                    }
                                }
                                ++n5;
                            }
                        }
                    }
                    ++n3;
                }
            }
        }
    }

    public void addReferenceHits(List<String> references) {
        for (String reference : references) {
            Integer hits = this.hitsPerReference.get(reference);
            hits = hits == null ? Integer.valueOf(1) : Integer.valueOf(hits + 1);
            this.hitsPerReference.put(reference, hits);
        }
    }

    protected Set<String> getClassesToExclude(String packageName) {
        HashSet<String> classes = new HashSet<String>();
        if (this.excludeClassNames != null) {
            String[] stringArray = this.excludeClassNames;
            int n = this.excludeClassNames.length;
            int n2 = 0;
            while (n2 < n) {
                String comparePackageName;
                String excludeClass = stringArray[n2];
                if (excludeClass.indexOf(46) > -1 && packageName.equals(comparePackageName = excludeClass.substring(0, excludeClass.lastIndexOf(46)))) {
                    classes.add(excludeClass);
                }
                ++n2;
            }
        }
        return classes;
    }

    protected ClassOrPackageDetails getNewPackageDetails(ClassOrPackageDetails originalPD, Set<String> classesToExclude) {
        ClassOrPackageDetails returnPD = null;
        String packageName = originalPD.getClassOrPackageName();
        Map<String, ClassOrPackageOccurrence> references = originalPD.getReferenceAndLineInfo();
        Set<String> referenceNames = references.keySet();
        for (String referenceKey : referenceNames) {
            int lineNumber;
            ClassOrPackageOccurrence copo = references.get(referenceKey);
            boolean skipZeroLines = copo.getReturnTypeOccurrences() > 0 || copo.getAnnotationOccurrences() > 0 || copo.getCatchExceptionOccurrences() > 0 || copo.getThrowsExceptionOccurrences() > 0 || copo.getParameterOccurrences() > 0;
            List<String> classNames = copo.getLineNumberClassNames();
            ArrayList<Integer> newLines = new ArrayList<Integer>();
            List<Integer> lines = copo.getLineNumbers();
            int size = lines.size();
            int i = 0;
            while (i < size) {
                String relatedClassName;
                Integer lineInt = lines.get(i);
                lineNumber = lineInt;
                if (!(lineNumber == 0 && skipZeroLines || classesToExclude.contains(relatedClassName = classNames.get(i)))) {
                    newLines.add(lineInt);
                }
                ++i;
            }
            for (Integer lineInt : newLines) {
                lineNumber = lineInt;
                if (returnPD == null) {
                    returnPD = new ClassOrPackageDetails(packageName, referenceKey, lineNumber);
                    continue;
                }
                returnPD.addOccurrence(referenceKey, lineNumber);
            }
            if (!skipZeroLines) continue;
            returnPD = this.processClassNames(returnPD, classesToExclude, copo.getAnnotationClassNames(), packageName, referenceKey, 2);
            returnPD = this.processClassNames(returnPD, classesToExclude, copo.getCatchExceptionClassNames(), packageName, referenceKey, 6);
            returnPD = this.processClassNames(returnPD, classesToExclude, copo.getParameterClassNames(), packageName, referenceKey, 3);
            returnPD = this.processClassNames(returnPD, classesToExclude, copo.getThrowsExceptionClassNames(), packageName, referenceKey, 5);
            returnPD = this.processClassNames(returnPD, classesToExclude, copo.getReturnTypeClassNames(), packageName, referenceKey, 1);
        }
        return returnPD;
    }

    protected ClassOrPackageDetails processClassNames(ClassOrPackageDetails pd, Set<String> classesToExclude, List<String> classNames, String packageName, String referenceKey, int type) {
        for (String className : classNames) {
            if (classesToExclude.contains(className)) continue;
            if (pd == null) {
                pd = new ClassOrPackageDetails(packageName, referenceKey, 0, type);
                continue;
            }
            pd.addOccurrence(referenceKey, 0, type);
        }
        return pd;
    }
}

